<?php

class FrontController extends BaseController {
    
    protected $layout = 'layout.basic_front';

    protected $_FRONTCONST;

    public function __construct()
    {
	$articleclass = \ArticleClass::where('is_available', 1)->get();
	
	$this->_FRONTCONST = array();
	$this->_FRONTCONST["HEADER_BUTTONS"] = $articleclass;
	$this->_FRONTCONST["LOGO"] = asset('images/Logo.png');
	$this->_FRONTCONST["LOOKNOW_CSS"] = asset('css/looknow.css');
	$this->_FRONTCONST["COL_COUNT"]=1;

	$bloggers = DB::table('bloggers')->get();
        foreach($bloggers as $blogger)
        {
                $like_num = DB::table('action_log')->where('object','ARTICLE')->where('blogger_id',$blogger->id)->where('action','LIKE')->count();
                $post_num = DB::table('myadmin_articles')->where('blogger_id',$blogger->id)->count();
	        DB::table('bloggers')->where('id',$blogger->id)->update(array('like_num'=>$like_num, 'post_num'=>$post_num));
        }
	
    }

    public function getIndex()
    {
		$home = \Home::all();
		$homeslide = \HomeSlide::all();
		$articles = \Article::all();
		$articlesnew = \Article::orderBy('updated_at','desc')->get();
		$articleclass = \ArticleClass::where('is_available', 1)->get();
		$users = \BloggerUser::all();
		$likearticles = \Action::where('action', 'LIKE')->where('object','ARTICLE')->get();
		$sortcat = array();
		$sortcatnew = array();
		$username = array();
		$userphoto = array();

        $option = array();
        foreach ($articleclass as $category) {
            $option[$category->id] = $category->title;
        }

		foreach($articles as $article){		// get tags , sort by descending
			$tags[] = $article->tag1;
			$tags[] = $article->tag2;
			$tags[] = $article->tag3;
		}
		$tags = array_count_values($tags);
		arsort($tags);
		unset($tags[""]);
		$tags = array_slice($tags, 0, 10);

		foreach ($users as $user){			// get blogger's name
			$username[$user->id] = $user->name;
			$userphoto[$user->id] = $user->photo;
		}


		foreach ($likearticles as $like){		// calculate article's liked number
			$likearticle[] = $like->object_id;
		}
		$likearticle = array_count_values($likearticle);
		arsort($likearticle);

		foreach ($likearticle as $key=>$value){		// sort the article by liked number
			foreach ($articles as $article){
				if($key == $article->id){
					$sortarticle[] = $article;
				}
			}
		}

		foreach ($articles as $article){
			$tmp = 0;
			foreach ($likearticle as $key=>$value){
				if($article->id == $key){
					$tmp = 1;
					break;
				}
			}
			if($tmp == 1)
				continue;
			else
				$sortarticle[] = $article;
		}
		
		foreach ($articlesnew as $new)		// sort the article by time
			$articletime[] = $new;


		if(isset($_GET['cid'])){			// choose specific category
			foreach($sortarticle as $sort){
				if($sort->category == $_GET['cid'])
					$sortcat[] = $sort;
			}
			foreach($articletime as $sort){
				if($sort->category == $_GET['cid'])
					$sortcatnew[] = $sort;
			}
			if(Session::get('cid') != $_GET['cid'] || !Session::has('cid')){
				Session::put('cid',$_GET['cid']); 
			}
			$sortarticle = $sortcat;
			$articletime = $sortcatnew;
		}
		else if(isset($_GET['tag'])){			// choose specific tag
			foreach($sortarticle as $sort){
				if($sort->tag1 == $_GET['tag'] || $sort->tag2 == $_GET['tag'] || $sort->tag3 == $_GET['tag'])
					$sortcat[] = $sort;
			}
			foreach($articletime as $sort){
				if($sort->tag1 == $_GET['tag'] || $sort->tag2 == $_GET['tag'] || $sort->tag3 == $_GET['tag'])
					$sortcatnew[] = $sort;
			}
			if(Session::get('tag') != $_GET['tag'] || !Session::has('tag')){
				Session::put('tag',$_GET['tag']); 
			}
			$sortarticle = $sortcat;
			$articletime = $sortcatnew;
		}
		else if(isset($home[0]->tag) && ($home[0]->tag != "")){			// choose specific tag 品牌聯名
			foreach($sortarticle as $sort){
				if($sort->tag1 == $home[0]->tag || $sort->tag2 == $home[0]->tag || $sort->tag3 == $home[0]->tag)
					$sortcat[] = $sort;
			}
			foreach($articletime as $sort){
				if($sort->tag1 == $home[0]->tag || $sort->tag2 == $home[0]->tag || $sort->tag3 == $home[0]->tag)
					$sortcatnew[] = $sort;
			}
			$sortarticle = $sortcat;
			$articletime = $sortcatnew;

//			return $sortarticle;
		}

		if(!isset($_GET['tag'])){
			Session::forget('tag');
		}
		if(!isset($_GET['cid'])){
			Session::forget('cid');
		}

//		return $sortarticle;
		$slicearticle = array_slice($sortarticle, 0, 3);
		$slicearticlenew = array_slice($articletime, 0, 3);

//		return $slicearticle;
		if(Session::get('userId') ==1 || !Session::has('userId')){
			Session::put('userId','1'); 
			Session::put('userName','Visitor');
		}
	
        return View::make('front.index')
			->withHome($home)
			->withOption($option)
			->withHomeslides($homeslide)
			->withTags($tags)
			->withArticleclass($articleclass)
			->withArticles($slicearticle)
			->withArticlesnew($slicearticlenew)
			->withUsername($username)
			->withUserphoto($userphoto)
			->withLikearticle($likearticle)
			->with('_FRONTCONST', $this->_FRONTCONST);

    }

    public function getDeleteComment($id)
    {
        DB::table('article_comments')->where('id',$id)->delete();
        return Redirect::back();
    }

    public function postNewcomment()
    {
        $userInput = Input::all();
        if(Session::has('userId'))
                $userId = Session::get('userId');
        else
                $userId =  Session::get('id');
        if(Session::has('userName'))
                 $userName = Session::get('userName');
        else
                $userName =  Session::get('id');
        $comment = DB::table('article_comments')->insert(array(
                                                'blogger_id' => $userInput['blogger_id'],
                                                'comment_content' => $userInput['comment_content'],
                                                'commender_id' => $userId,
                                                'commender' => $userName,
                                                'article_id' => $userInput['article_id']));
        return Redirect::to(URL::previous() . '#finish_comment');//back();
    }


//////create fb login account
   public function getFblogin($profile)
   {
        $profile = explode(",",$profile);
        if(!(isset($profile[3])))
                $profile[3]="";

        $chk_count= DB::table('users')
            ->where('account','=',$profile[1])
            //->where('email','=',$profile[3])
            ->count();

          if($chk_count == 0){
            try{
                DB::table('users')->insert(array(
                    array(
                        'register_time'=>date('Y-m-d H:i'),
                        'login_type'=>"Facebook",
                        'status'=>'正常',
                        'authority'=>'一般',
                        'img_path'=>'https://graph.facebook.com/'.$profile[1].'/picture?type=large',
                        'email'=>$profile[3],
                        'account'=>$profile[1],
                        'name'=>$profile[0],
                        'gender'=>'male',//$profile[2],
                        'phone'=>"N",
                        'comment_is_available'=>'1',
                        'level'=>"種子帳戶"),
                ));

            }
            catch(Exception $e)
            {
                return Redirect::back()->withErrors($e);
            }
        }
        $account= DB::table('users')
            ->where('account','=',$profile[1])
            ->first();
        Session::put('userId',$account->id);
        Session::put('userName',$account->name);
        $articles = DB::table('myadmin_articles')->get();
        $articlesclass = DB::table('myadmin_article_classes')->get();

        return Redirect::back();
   }

    public function postLogin()
    {
        $salt = Config::get('Myadmin::admin.salt');
        $passwd = crypt(Input::get('password'), $salt);
        $chk_account = DB::table('users')->where('account',Input::get('UserAccount'))->where('password',$passwd)->count();
        if($chk_account > 0){
                $user = DB::table('users')->where('account',Input::get('UserAccount'))->where('password',$passwd)->first();
                if($user->is_available){
                        Session::put('userId',$user->id);
                        Session::put('userName',$user->name);

                        return Redirect::back();
                }
                else
                        return Redirect::back()->withErrors('權限問題')->withInput();
        }
        else
        {
                return Redirect::back()->withErrors('帳號密碼有誤！！')->withInput();
        }
    }


    public function getLogout()
    {
        Session::forget('userId');
        Session::forget('userName');
        return Redirect::to('admin/front');
    }

    public function getLike($article_id, $blogger_id)
    {
        $object ='ARTICLE';
        $action ='LIKE';
        $chk_like = DB::table('action_log')
                        ->where('object',$object)
                        ->where('object_id',$article_id)
                        ->where('action',$action)
                        ->where('user_id',Session::get('userId'))->count();
        if($chk_like == 0)
        {
                $comment = DB::table('action_log')->insert(array(
                                                'action' => $action,
                                                'object_id' => $article_id,
                                                'object' => $object,
                                                'blogger_id' => $blogger_id,
                                                'user_id' => Session::get('userId'),
                                                'created_at' => DB::raw('CURRENT_TIMESTAMP')));
        }
        else{
                DB::table('action_log')
                        ->where('object',$object)
                        ->where('object_id',$article_id)
                        ->where('action',$action)
                        ->where('user_id',Session::get('userId'))->delete();
        }

        $like_num = DB::table('action_log')->where('object','ARTICLE')->where('object_id',$article_id)->where('action','LIKE')->count();
        $Alllike_num = DB::table('action_log')->where('object','ARTICLE')->where('blogger_id',$blogger_id)->where('action','LIKE')->count();

        //update the like_num to db
        DB::table('myadmin_articles')->where('id', $article_id)->update(array('likes'=>$like_num));
        DB::table('bloggers')->where('id', $blogger_id)->update(array('like_num'=>$Alllike_num));

        return Redirect::back();
    }

	public function getAppend()
	{
		$home = \Home::all();
		$articles = \Article::all();
		$articlesnew = \Article::orderBy('updated_at','desc')->get();
		$likearticles = \Action::where('action', 'LIKE')->where('object','ARTICLE')->get();
        if($_GET['popular']){
			foreach ($likearticles as $like){		// calculate article's liked number
                $likearticle[] = $like->object_id;
            }

			$likearticle = array_count_values($likearticle);
			arsort($likearticle);

			foreach ($likearticle as $key=>$value){		// sort the article by liked number
				foreach ($articles as $article){
					if($key == $article->id){
						$sortarticle[] = $article;
					}
				}
            }

			foreach ($articles as $article){
				$tmp = 0;
				foreach ($likearticle as $key=>$value){
					if($article->id == $key){
						$tmp = 1;
						break;
					}
				}
				if($tmp == 1)
					continue;
				else {
                    $sortarticle[] = $article;
                }
			}
			if(Session::has('cid')){						// if specify category
				foreach($sortarticle as $sort){
					if($sort->category == Session::get('cid'))
						$sortcat[] = $sort;
				}	
				$sortarticle = $sortcat;
			}
			else if(Session::has('tag')){						// if specify tag
				foreach($sortarticle as $sort){
					if($sort->tag1 == Session::get('tag') || $sort->tag2 == Session::get('tag') || $sort->tag3 == Session::get('tag'))
						$sortcat[] = $sort;
				}	
				$sortarticle = $sortcat;
			}
			else if(isset($home[0]->tag) && ($home[0]->tag != "")){
				foreach($sortarticle as $sort){
					if($sort->tag1 == $home[0]->tag || $sort->tag2 == $home[0]->tag || $sort->tag3 == $home[0]->tag)
						$sortcat[] = $sort;
				}	
				$sortarticle = $sortcat;

			}

			$slicearticle = array_slice($sortarticle, $_GET['from'], 3);
		}
        else{
            foreach ($articlesnew as $new)		// sort the article by time
            {
                $articletime[] = $new;
                /*
                if(Session::get('userId') == $new->object_id) {
                    $articletime[$count]["user_click"] = 1;			
                } else {
                    $articletime[$count]["user_click"] = 0;			
                }
                $count++;
                 */
            }

			if(Session::has('cid')){
				foreach($articletime as $sort){
					if($sort->category == Session::get('cid'))
						$sortcat[] = $sort;
				}				
				$articletime = $sortcat;
			}
			else if(Session::has('tag')){						// if specify tag
				foreach($articletime as $sort){
					if($sort->tag1 == Session::get('tag') || $sort->tag2 == Session::get('tag') || $sort->tag3 == Session::get('tag'))
						$sortcat[] = $sort;
				}	
				$articletime = $sortcat;
			}
			else if(isset($home[0]->tag) && ($home[0]->tag != "")){
				foreach($articletime as $sort){
					if($sort->tag1 == $home[0]->tag || $sort->tag2 == $home[0]->tag || $sort->tag3 == $home[0]->tag)
						$sortcat[] = $sort;
				}	
				$articletime = $sortcat;

			}
			$slicearticle = array_slice($articletime, $_GET['from'], 3);
		}
		return $slicearticle;
	}

	public function getShopmap($x, $y)
	{
//		return $x."yoo".$y;
//		return $_GET['near'];
		$shops = \Shops::all();
		$count = 0;

		foreach ($shops as $shop){
			$distance = ((int)$x-(int)$shop->position_x)*((int)$x-(int)$shop->position_x)+
				((int)$y-(int)$shop->position_y)*((int)$y-(int)$shop->position_y);
//			return $distance;
			$unsort[$shop->id] = $distance;
		}
		asort($unsort);
//		$sort = array_splice($sort, 0, 3);
		foreach ($unsort as $key=>$value){
			$count++;
			if($count > 3)
				break;
			else
				$sort[] = \Shops::findOrFail($key);
		}
		if(isset($_GET['near']) && $_GET['near'] == 0){
			$one['position_x'] = $x;
			$one['position_y'] = $y;
			unset($sort);
			$sort[] = $one;
		}

		return View::make('front.shop_map')
			->withLatitude($x)
			->withLongitude($y)
			->withSort($sort)
//			->withPosition($position)
			->with('_FRONTCONST', $this->_FRONTCONST);
	}

	public function getProduct($id)
	{
		$product = \Product::findOrFail($id);
		$productdetail = \ProductDetail::all();
		$brands = \Brands::all();
		$productimg = array();
		$articles = \Article::all();
		$users = \BloggerUser::all();
//		return $articles;

		foreach ($users as $user){			// get blogger's name
			$username[$user->id] = $user->name;
			$userphoto[$user->id] = $user->photo;
		}

		foreach ($productdetail as $detail){		// get product's image
			if($detail->product_id == $id)
				$productimg[] = $detail;
		}
		foreach ($brands as $brand)					// get product's brand
			$br[$brand->id] = $brand;		

		$format = explode(",",$product->format);

		foreach ($articles as $article){			// get articles which mention product is same as products.
			if($article->mention_product != null && ($product->tag_1 == $article->mention_product || $product->tag_2 == $article->mention_product || $product->tag3 == $article->mention_product) )
				$article_product[] = $article;
		}
		if(!isset($article_product))
			$article_product = null;

//		return $article_product;
		return View::make('front.product')
			->withProduct($product)
			->withProductimg($productimg)
			->withBrands($br)
			->withFormat($format)
			->withArticles($article_product)
			->withUserphoto($userphoto)
			->withUsername($username)
			->with('_FRONTCONST', $this->_FRONTCONST);
	}

	public function getCart($id)
	{
		$cookies = $_COOKIE;
		$products = array();
		$productimgs = array();
		$productnumber = array();
		$productformat = array();
		$productposition = array();
		$formats = array();
		$format;

		foreach ($cookies as $key=>$value){			// parse cookies
			if(is_numeric($key)){
				$detail = explode(',',$value);
				$format = \Product::where('id',$key)->lists('format');
				
				$format = explode(',',$format[0]);

				for($i=0 ; $i<count($detail) ; $i+=2){
					if($detail[$i] != ""){
						$products[] = \Product::findOrFail($key);
						$productimgs[] = \ProductDetail::where('product_id',$key)->first();
						$productnumber[] = $detail[$i];
						for($j=0 ; $j<count($format) ; $j++){
							if($format[$j] == $detail[$i+1]){
								$productformat[] = $j;
								break;
							}
						}
//						$productformat[] = $detail[$i+1];
						$productposition[] = $i;
						$formats[] = $format;
					}
				}
			}
		}
//		return $productformat;
		return View::make('front.cart')
			->withProducts($products)
			->withProductimgs($productimgs)
			->withProductnumber($productnumber)
			->withProductformat($productformat)
			->withProductposition($productposition)
			->withFormats($formats)
			->with('_FRONTCONST', $this->_FRONTCONST);
	}


	public function getCleancookie($pid, $position)
	{
		$cookies = $_COOKIE;
		$str = "";

		foreach ($cookies as $key=>$value){			// parse cookies
			if(is_numeric($key) && $key == $pid){
				$detail = explode(',',$value);
				for($i=0 ; $i<count($detail) ; $i+=2){
					if($detail[$i] != "" && $i != $position){
						$str = $str.$detail[$i].','.$detail[$i+1].',';
					}
				}
				unset($_COOKIE[$pid]);		// clean cookies and reset it.
				setcookie($pid, $str, time()+ (60 * 60 * 24 * 365 * 20), '/');
			}
		}
		
		return Redirect::to('admin/front/cart/1');	
	}

	public function getCheckout($id)
	{
		$homeslide = \HomeSlide::all();
		$articleclass = \ArticleClass::where('is_available', 1)->get();

		return View::make('front.checkout')
			->withArticleclass($articleclass)
			->withHomeslides($homeslide)
			->with('_FRONTCONST', $this->_FRONTCONST);
	}

	public function checkstore()
	{
        $userInput = Input::all();
		$cookies = $_COOKIE;
		$user = \User::findOrFail(Session::get('userId'));
		$obj = new StdClass();
		$total = ""; 
		$amount = "";

        $validator = Validator::make(
            $userInput,
            array(
                'firstname' => 'required',
                'lastname' => 'required',
                'email' => 'required',
                'password' => 'required',
                'password2' => 'same:password'
            )
        );
		if($validator->passes()){
		$transaction = new \Transaction;
			foreach ($cookies as $key=>$value){			// parse cookies
				if(is_numeric($key)){
					$product = \Product::findOrFail($key);
					$detail = explode(',',$value);
					$obj->id = $key;
					for($i=0 ; $i<count($detail) ; $i+=2){
						if($detail[$i] != ""){
							$total += (int)$product->selling_price;
							$obj->num = $detail[$i];
							$amount += (int)$detail[$i];
							$obj->format = $detail[$i+1];
							$products_json[] = (array)$obj;
						}
					}
//					unset($_COOKIE[$key]);		// clean cookies and reset it.
//					setcookie($key, null, -1, '/');
				}
			}
			$json = json_encode($products_json);
			//return $this->generatorPasswordNum(8);

			$transaction->user_id = Session::get('userId');
			$transaction->order_code = $this->generatorPasswordNum(8);
			$transaction->money = $total;
			$transaction->address = $user->address1;
			$transaction->products_json = $json;
			$transaction->mail = $userInput['email'];
			$transaction->amount = $amount;
			$transaction->status = "尚未付款";

			$transaction->save();
			return Redirect::to('admin/receipt/1');
		}
		else
			return Redirect::back()->withInput()->withErrors($validator);
	}


	public function getReceipt($id)
	{
		$cookies = $_COOKIE;

		foreach ($cookies as $key=>$value){			// parse cookies
			if(is_numeric($key)){
				$detail = explode(',',$value);
				for($i=0 ; $i<count($detail) ; $i+=2){
					if($detail[$i] != ""){
						$find = \Product::findOrFail($key);
						$products[] = $find;
						$productimgs[] = \ProductDetail::where('product_id',$key)->first();
						$productnumber[] = $detail[$i];
						$productformat[] = $detail[$i+1];
						$productprice[] = (int)$detail[$i]*(int)$find->selling_price;
					}
				}
//					unset($_COOKIE[$key]);		// clean cookies and reset it.
//					setcookie($key, null, -1, '/');
			}
		}

		return View::make('front.receipt')
			->withProducts($products)
			->withProductimgs($productimgs)
			->withProductnumber($productnumber)
			->withProductformat($productformat)
			->withProductprice($productprice)
			->with('_FRONTCONST',$this->_FRONTCONST);
	}

    public function getBrandlist($id)
	{
		$brands = \Brands::all();
		$brandsnew = \Brands::orderBy('updated_at','desc')->get();
		$brandslike = \Action::where('action', 'FOLLOW')->where('object','BRAND')->get();
//		return $brandslike;

		foreach ($brandslike as $like){		// calculate article's liked number
			$likebrands[] = $like->object_id;
		}
		$likebrands = array_count_values($likebrands);
		arsort($likebrands);
//		return $likebrands;
		foreach ($likebrands as $key=>$value){		// sort the article by liked number
			foreach ($brands as $brand){
				if($key == $brand->id){
					$sortbrand[] = $brand;
				}
			}
		}
		foreach ($brands as $brand){
			$tmp = 0;
			foreach ($likebrands as $key=>$value){
				if($brand->id == $key){
					$tmp = 1;
					break;
				}
			}
			if($tmp == 1)
				continue;
			else
				$sortbrand[] = $brand;
		}

		foreach ($brandsnew as $new)		// sort brand by its time stamp
			$brandstime[] = $new;
		
//		$sortbrand = array_slice($sortbrand, 0, 16);
//		return $sorbrand;
//		$sortbrandstime = array_slice($brandstime, 0, 16);
		$sortbrandstime = $brandstime;
		return View::make('front.brandlist')
			->withBrandsnew($sortbrandstime)
			->withBrandspopular($sortbrand)
			->with('_FRONTCONST',$this->_FRONTCONST);
	}
	
	public function getAppendbrand()
	{
		$brands = \Brands::all();
		$brandsnew = \Brands::orderBy('updated_at','desc')->get();
		$brandslike = \Action::where('action', 'FOLLOW')->where('object','BRAND')->get();
			
		if($_GET['popular']){
			foreach ($brandslike as $like){		// calculate article's liked number
				$likebrands[] = $like->object_id;
			}
			$likebrands = array_count_values($likebrands);
			arsort($likebrands);
			//		return $likebrands;
			foreach ($likebrands as $key=>$value){		// sort the article by liked number
				foreach ($brands as $brand){
					if($key == $brand->id){
						$sortbrand[] = $brand;
					}
				}
			}
			foreach ($brands as $brand){
				$tmp = 0;
				foreach ($likebrands as $key=>$value){
					if($brand->id == $key){
						$tmp = 1;
						break;
					}
				}
				if($tmp == 1)
					continue;
				else
					$sortbrand[] = $brand;
			}
			$slicebrand = array_slice($sortbrand, $_GET['from'], 16);
		}
		else{
			foreach ($brandsnew as $new)		// sort brand by its time stamp
				$brandstime[] = $new;

			$slicebrand = array_slice($brandstime, $_GET['from'], 16);
		}

		return $slicebrand;
	}

    public function getBrandinfo($brand_id)
    {
		$brand = DB::table('brands')->where('id',$brand_id)->first();	
		$products = \Product::where('subheading',$brand_id)->get();
		$likearticles = \Action::where('action', 'LIKE')->where('object','ARTICLE')->get();
		$users = \BloggerUser::all();
		$article = array();
		$dirty = 1;
		$like = 0;
	
		foreach ($users as $user){			// get blogger's name
			$username[$user->id] = $user->name;
			$userphoto[$user->id] = $user->photo;
		}

		foreach ($likearticles as $likes){		// calculate article's liked number
			$likearticle[] = $likes->object_id;
		}
		$likearticle = array_count_values($likearticle);
		arsort($likearticle);

	foreach ($products as $product)	{
		$tags = array($product->tag_1, $product->tag_2, $product->tag_3);
		$getarticle = \Article::whereIn('mention_product', $tags)->get();
//		return $getarticle;
//		if($dirty!=1)
			$article[] = $getarticle;
//		else
//			$dirty = 2;
	}
	$article = array_unique($article);
	foreach($article as $art)
		for($i = 0 ; $i<count($art) ; $i++){
			$like += (int)$art[$i]->likes;
		}
//		return $like;
//	return $article;
	$followers_id = DB::table('action_log')->where('object','BRAND')->where('object_id',$brand_id)->where('action','FOLLOW')->select('user_id')->get();
	$isfollow = DB::table('action_log')->where('user_id',Session::get('userId'))->where('object','BRAND')->where('object_id',$brand_id)->where('action','FOLLOW')->count();
	$user_id = array();	
	foreach($followers_id as $follower)
	{
        array_push($user_id,$follower->user_id);
	}
	$user_id = array_unique($user_id);
	$followers = DB::table('users')->whereIn('id',$user_id)->get();	

	if(!isset($article[0]))
		$article[0] = null;

//	return $followers;
	return View::make('front.brand_info')
		->withBrand($brand)
		->withIsfollow($isfollow)
		->withArticles($article[0])
		->withFollowers($followers)
		->withLikes($like)
		->withUsername($username)
		->withUserphoto($userphoto)
		->withLikearticle($likearticle)
		->with('_FRONTCONST',$this->_FRONTCONST);
    }

	public function getHome()
    {
//        return View::make('front.follow');
    }

    public function getAbout()
    {
	return View::make('front.about')
                 ->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getSearchResult()
    {
	$searchInput = Input::all();	
	$lookers = DB::table('bloggers')->where('name','LIKE','%'.$searchInput['searchContent'].'%')->get();
	$brands = DB::table('brands')->where('name','LIKE','%'.$searchInput['searchContent'].'%')->get();
	$articles = DB::table('myadmin_articles')->where('title','LIKE','%'.$searchInput['searchContent'].'%')->get();	
	
	return View::make('front.search_result')
		 ->withColCount(1)
		 ->withSearchContent($searchInput['searchContent'])
		 ->withLookers($lookers)
		 ->withBrands($brands)
		 ->withArticles($articles)
                 ->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getLookers($load_start = 0)
    {
	$category = DB::table('blogger_classes')->where('is_available','1')->orderBy('id','desc')->get();
	$looker = DB::table('blogger_classes')->where('title','Looker')->orWhere('title','LOOKER')->first();
	$cate = $looker->id;
	if(isset($_GET['cate']))
	{
		$cate = $_GET['cate'];
		$chk = DB::table('bloggers')->where('category',$_GET['cate'])->count();
		if($chk <=0)
		{
			$cate=null;
			$first_looker = DB::table('bloggers')->orderBy('like_num','desc')->take(1)->first();
			$looker_select = DB::table('bloggers')->where('id','!=',$first_looker->id)->orderBy('like_num','desc');
			
		}
		else
		{
			$first_looker = DB::table('bloggers')->where('category',$_GET['cate'])->orderBy('like_num','desc')->take(1)->first();
			$looker_select = DB::table('bloggers')->where('category',$_GET['cate'])->where('id','!=',$first_looker->id)->orderBy('like_num','desc');
		}
	}
	else
	{
		$first_looker = DB::table('bloggers')->orderBy('like_num','desc')->take(1)->first();
		$looker_select = DB::table('bloggers')->where('id','!=',$first_looker->id)->orderBy('like_num','desc');
	}

	// 一次要load 出幾個 按more
	$load_start = $load_start + 1;
	$limit = 8 * $load_start;
	if($looker_select->count() >= $limit)
		$lookers = $looker_select->skip(0)->take($limit)->get();
	else{
		$lookers = $looker_select->take($looker_select->count())->get();
		$load_start = 'all';
	}

	//return $first_looker;
	$video_id = DB::table('myadmin_articles')->where('blogger_id',$first_looker->id)->get();
	$video_num = count($video_id);
	$isfollow = DB::table('action_log')->where('user_id',Session::get('userId'))->where('object','LOOKER')->where('object_id',$first_looker->id)->where('action','FOLLOW')->count();
	return View::make('front.lookers')
		->withRank(1)
		->withCateIndex($cate)
		->withLoadStart($load_start)
		->withIsfollow($isfollow)
		->withThisMonth(date('Y M'))
		->withLookerCategory($category)
		->withFirstLooker($first_looker)
		->withVideoNum($video_num)
		->withLookers($lookers)
		->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getLookerinfo($looker_id,$load_start = 0)
    {
	$looker = DB::table('bloggers')->where('id',$looker_id)->first();	
	$video_id = DB::table('myadmin_articles')->where('blogger_id',$looker->id)->get();

	//文章
	$video_select = DB::table('myadmin_articles')->where('blogger_id',$looker->id);
	// 一次要load 出幾個 按more
	$load_start = $load_start + 1;
	$limit = 3 * $load_start;
	if($video_select->count() >= $limit)
		$videos = $video_select->skip(0)->take($limit)->get();
	else{
		$videos = $video_select->take($video_select->count())->get();
		$load_start = 'all';
	}


	$video_num = count($video_id);
	$followers_id = DB::table('action_log')->where('object','LOOKER')->where('object_id',$looker->id)->where('action','FOLLOW')->select('user_id')->get();
	$isfollow = DB::table('action_log')->where('user_id',Session::get('userId'))->where('object','LOOKER')->where('object_id',$looker->id)->where('action','FOLLOW')->count();
	$user_id = array();	
	foreach($followers_id as $follower)
	{
                array_push($user_id,$follower->user_id);
	}
//	return $article_id;
	$followers = DB::table('users')->whereIn('id',$user_id)->get();	


	return View::make('front.looker_info')
		->withLoadStart($load_start)
		->withLooker($looker)
		->withIsfollow($isfollow)
		->withVideoNum($video_num)
		->withArticles($videos)
		->withFollowers($followers)
		->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getUserEdit()
    {
        $salt = Config::get('Myadmin::admin.salt');
	$userInput = Input::all();

	if($Input::has('img_path'))		
		$img_path = $userInput['img_path'];
	if($Input::has('user_name'))		
		$user_name = $userInput['user_name'];
	if($Input::has('pre-password'))		
		$pre_password =crypt($userInput['pre_password'], $salt);
	if($Input::has('new_password') && $Input::has('new_password'))
		if( $Input::get('new_password') == $Input::get('check_password'))		
			$new_password = $userInput['new_password'];
	return $new_password;
    }

    public function getProfile($load_start=0)
    {
	if(!Session::has('userId'))
		return Redirect::to('admin/front');

	$articleclass = \ArticleClass::where('is_available', 1)->get();
	$user = DB::table('users')->where('id',Session::get('userId'))->first();
	$collect_id = DB::table('action_log')->where('user_id',Session::get('userId'))->where('action','COLLECT')->select('object_id')->get();
	$collect_num = count($collect_id);
	$like_num = DB::table('action_log')->where('user_id',Session::get('userId'))->where('action','LIKE')->select('object_id')->count();
        $follow_num = count(DB::table('action_log')->where('user_id',Session::get('userId'))->where('object','LOOKER')->where('action','FOLLOW')->select('object_id')->get());

	$article_id = array();	
	foreach($collect_id as $article)
	{
                array_push($article_id,$article->object_id);
	}


	$collect_select = \Article::whereIn('id',$article_id);	
		
	// 一次要load 出幾個 按more
	$load_start = $load_start + 1;
	$limit = 3 * $load_start;
	if($collect_select->count() >= $limit)
		$collect_article = $collect_select->skip(0)->take($limit)->get();
	else{
		$collect_article = $collect_select->take($collect_select->count())->get();
		$load_start = 'all';
	}

	$followerd_id = DB::table('action_log')->where('object','LOOKER')->where('user_id',Session::get('userId'))->where('action','FOLLOW')->select('object_id')->get();
	$looker_id = array();	
	foreach($followerd_id as $follow)
	{
                array_push($looker_id,$follow->object_id);
	}
//	return $article_id;
	$follows = DB::table('bloggers')->whereIn('id',$looker_id)->get();	

	return View::make('front.profile_like')
		->withLoadStart($load_start)
		->withUser($user)
		->withLikeNum($like_num)
		->withCollectNum($collect_num)
		->withFollowNum($follow_num)
		->withFollows($follows)
		->withArticles($collect_article)
		->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getProfileFollow()
    {
	$user = DB::table('users')->where('id',Session::get('userId'))->first();
	$like_num = DB::table('action_log')->where('user_id',Session::get('userId'))->where('action','LIKE')->select('object_id')->count();
        $follow_num = count(DB::table('action_log')->where('user_id',Session::get('userId'))->where('object','LOOKER')->where('action','FOLLOW')->select('object_id')->get());
	$lookers_id = DB::table('action_log')->where('user_id',Session::get('userId'))->where('object','LOOKER')->where('action','FOLLOW')->select('object_id')->get();
        $id = array();
        foreach($lookers_id as $looker)
        {
                array_push($id,$looker->object_id);
        }
//      return $article_id;
        $lookers = DB::table('bloggers')->whereIn('id',$id)->get();

	return View::make('front.profile_follow')
		->withUser($user)
		->withLikeNum($like_num)
		->withFollowNum($follow_num)
		->withLookers($lookers)
		->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getVideo($article_id)
    {
	//if(!Session::has('userId'))
	//	return Redirect::to('admin/front');
	$user = "visitor";
	if(Session::get('userId') != 1){
		$user_info = DB::table('users')->where('id',Session::get('userId'))->first();
		$user = $user_info->img_path;
	}
	$article = \Article::where('id', $article_id)->first();
	$category = \ArticleClass::where('id', $article->category)->first();
	$like_num = DB::table('action_log')->where('object','ARTICLE')->where('object_id',$article_id)->where('action','LIKE')->count();
	$islike = DB::table('action_log')->where('object','ARTICLE')->where('object_id',$article_id)->where('action','LIKE')->where('user_id',Session::get('userId'))->count();
	$isCollect = DB::table('action_log')->where('object','ARTICLE')->where('object_id',$article_id)->where('action','COLLECT')->where('user_id',Session::get('userId'))->count();
	$blogger = \DB::table('bloggers')->where('id',$article->blogger_id)->first();
	$isfollow = DB::table('action_log')->where('object','LOOKER')->where('object_id',$blogger->id)->where('action','FOLLOW')->where('user_id',Session::get('userId'))->count();
	$comments = \Comments::join('users','users.id','=','article_comments.commender_id')
			->where('article_comments.article_id',$article_id)
			->select(DB::raw('article_comments.blogger_id as blogger_id, article_comments.comment_content as comment_content, article_comments.commender as commender, users.img_path as img_path'))->orderBy('article_comments.id','asc')->get();
        //browse
                DB::table('action_log')->insert(array(
                                                'action' => 'BROWSE',
                                                'object_id' => $article_id,
                                                'object' => 'ARTICLE',
                                                'blogger_id' => $blogger->id,
                                                'user_id' => Session::get('userId'),
                                                'created_at' => DB::raw('CURRENT_TIMESTAMP')));
	//find the same tag in table	
	$tag = array($article->tag1,$article->tag2,$article->tag3);
	$other_article_id = \Article::whereIn('tag1',$tag)
				->where('id','!=',$article_id)
				->orWhereIn('tag2',$tag)
				->where('id','!=',$article_id)
				->orWhereIn('tag3',$tag)
				->where('id','!=',$article_id)->select('id')->get();
	$article_num = count($other_article_id);
	$other_article_id_array = array();
	foreach($other_article_id as $id){
		array_push($other_article_id_array,$id->id);
	}

	$other_article=\Article::whereIn('myadmin_articles.id',$other_article_id_array)->orderBy('likes','desc');
//			->select('');
//	return $other_article;

	if($article_num >= 3)
		$other_articles = $other_article->take(3)->get();
	elseif($article_num==0)   //如果沒有相同的tag
		$other_articles = \Article::where('blogger_id',$article->blogger_id)->take(3)->get();
	else
		$other_articles = $other_article->take($article_num)->get();
        return View::make('front.video')
			->withCategory($category)
			->withIslike($islike)
			->withIsCollect($isCollect)
			->withIsfollow($isfollow)
			->withLikeThis($like_num)
			->withUserinfo($user)
			->withLooker($blogger)
			->withArticle($article)
			->withCommentNum(0)
			->withComments($comments)
			->withOtherArticles($other_articles)
			->with('_FRONTCONST',$this->_FRONTCONST);
    }

    public function getIslike()
    {
	$chk = DB::table("action_log")->where('user_id',$_GET['user_id'])->where('object','ARTICLE')->where('object_id',$_GET['article_id'])->where('action','LIKE')->count();	
	return $chk;
    }

    public function getOneAction()
    {
	$action = $_GET['action'];
	$object = $_GET['object'];
	$object_id = $_GET['object_id'];
	$user_id = $_GET['user_id'];
	$blogger_id = $_GET['blogger_id'];
	$islike = 0;

        $chk = DB::table("action_log")
                        ->where('object',$object)
                        ->where('object_id',$object_id)
                        ->where('action',$action)
                        ->where('user_id',$user_id)->count();
        if($chk == 0)
        {
                DB::table('action_log')->insert(array(
                                                'action' => $action,
                                                'object_id' => $object_id,
                                                'object' => $object,
                                                'blogger_id' => $blogger_id,
                                                'user_id' => $user_id,
                                                'created_at' => DB::raw('CURRENT_TIMESTAMP')));
		$islike = 1;
        }
        else{
                DB::table('action_log')
                        ->where('object',$object)
                        ->where('object_id',$object_id)
                        ->where('action',$action)
                        ->where('user_id',$user_id)->delete();
        }
	
        $num = DB::table("action_log")
                        ->where('object',$object)
                        ->where('object_id',$object_id)
                        ->where('action',$action)->count();
	DB::table("myadmin_articles")->where("id",$object_id)->update(array(
                                'likes'=> $num,));

		return array("show"=>$islike, "num"=>$num); 
    }

    public function getActions($object,$object_id,$action,$blogger_id)
    {
      if($action=='LIKE' || $action=='FOLLOW' || $action =='COLLECT')
      {	
        $chk = DB::table('action_log')
                        ->where('object',$object)
                        ->where('object_id',$object_id)
                        ->where('action',$action)
                        ->where('user_id',Session::get('userId'))->count();
        if($chk == 0)
        {
                DB::table('action_log')->insert(array(
                                                'action' => $action,
                                                'object_id' => $object_id,
                                                'object' => $object,
                                                'blogger_id' => $blogger_id,
                                                'user_id' => Session::get('userId'),
                                                'created_at' => DB::raw('CURRENT_TIMESTAMP')));
        }
        else{
                DB::table('action_log')
                        ->where('object',$object)
                        ->where('object_id',$object_id)
                        ->where('action',$action)
                        ->where('user_id',Session::get('userId'))->delete();
        }
	if($object == 'LOOKER'){
		$follow_num = DB::table('action_log')->where('blogger_id',$blogger_id)->where('action','FOLLOW')->count();
		DB::table('bloggers')->where('id',$blogger_id)->update(array('follow_num'=>$follow_num));
	}
	if($object == 'BRAND'){
		$follow_num = DB::table('action_log')->where('object',$object)->where('object_id',$object_id)->where('action','FOLLOW')->count();
		DB::table('brands')->where('id',$object_id)->update(array('follow'=>$follow_num));
	}


		
     }
     else
	{
                DB::table('action_log')->insert(array(
                                                'action' => $action,
                                                'object_id' => $object_id,
                                                'object' => $object,
                                                'blogger_id' => $blogger_id,
                                                'user_id' => Session::get('userId'),
                                                'created_at' => DB::raw('CURRENT_TIMESTAMP')));		
	}
	if($action == 'goWeb' || $action == 'goStore' ||$action == 'goShop')
		return '1';

	return Redirect::back();
   }

	public function generatorPasswordNum($num)
	{
		$password_len = $num;
		$password = '';

		// remove o,0,1,l
		$word = '0123456789';
		$len = strlen($word);

		for ($i = 0; $i < $password_len; $i++) {
			$password .= $word[rand() % $len];
		}

		return $password;
	}

}
