<?php

class HomeController extends BaseController {
    
    protected $layout = 'layout.basic';

    public function getIndex()
    {
        return $this->getHome();
    }

    public function getHome()
    {
        return View::make('front.follow');
    }
    
    public function getBloggerLike($id)
    {
        $follows = BloggerLike::join('bloggers', 'bloggers.id', '=', 'myadmin_blogger_like.blogger_id')
            ->join('users', 'users.id', '=', 'myadmin_blogger_like.user_id')
                ->where('myadmin_blogger_like.blogger_id', DB::raw($id))
                ->orderBy("myadmin_blogger_like.created_at", 'desc')
                ->select(DB::raw('users.name as user_name
                , users.email as email, users.img_path as img_path'))->get();
	
	
        $blogger = BloggerLike::join('bloggers', 'bloggers.id', '=', 'myadmin_blogger_like.blogger_id')
            ->where('myadmin_blogger_like.blogger_id', DB::raw($id))
            ->get();
/*
        $sql = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->join('users', 'users.id', '=', 'myadmin_follows.user_id')
                ->where('myadmin_follows.blogger_id', DB::raw($id))
                ->orderBy("myadmin_follows.created_at", 'desc')
                ->select(DB::raw('users.name as user_name
                , bloggers.name as blogger_name'))
            ->toSql();
 */
        if(!isset($blogger[0])) {
            // if empty
            return Redirect::back();
        }

        return View::make('front.follow')
            ->withFollows($follows)
            ->withBlogger($blogger[0]);
    }

    public function getFollow($id)
    {
        $follows = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->join('users', 'users.id', '=', 'myadmin_follows.user_id')
                ->where('myadmin_follows.blogger_id', DB::raw($id))
                ->orderBy("myadmin_follows.created_at", 'desc')
                ->select(DB::raw('users.name as user_name
                , users.email as email, users.img_path as img_path'))->get();
	
	
        $blogger = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->where('myadmin_follows.blogger_id', DB::raw($id))
            ->get();
/*
        $sql = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->join('users', 'users.id', '=', 'myadmin_follows.user_id')
                ->where('myadmin_follows.blogger_id', DB::raw($id))
                ->orderBy("myadmin_follows.created_at", 'desc')
                ->select(DB::raw('users.name as user_name
                , bloggers.name as blogger_name'))
            ->toSql();
*/
        if(!isset($blogger[0])) {
            // if empty
            return Redirect::back();
        }

        return View::make('front.follow')
            ->withFollows($follows)
            ->withBlogger($blogger[0]);
    }

    public function getArticle($id=null)
    {
        if ($id) {
            $article = Article::findOrFail($id);
            $article->viewed += 1;
            $article->save();
            return View::make('oneArticle')
                ->withArticle($article)
                ->withCategories(ArticleClass::all())
                ->withHottest(Article::orderBy('viewed', 'DESC')->take(3)->get())
                ->withName('article');

        }else {
            return View::make('article')
                ->withTitle("最新文章")
                ->withArticles(Article::orderBy('id', 'DESC')->paginate(10))
                ->withCategories(ArticleClass::all())
                ->withHottest(Article::orderBy('viewed', 'DESC')->take(3)->get())
                ->withName('article');
        }
    }

    public function getArticleclass($id=0)
    {
        $class = ArticleClass::findOrFail($id);
        return View::make('article')
            ->withTitle($class->title)
            ->withArticles($class->articles()->paginate(10))
            ->withCategories(ArticleClass::all())
            ->withHottest(Article::orderBy('viewed', 'DESC')->take(3)->get())
            ->withName('article');
    }

    public function getProduct($id=null)
    {
        if ($id) {
            $product = Product::findOrFail($id);
            return View::make('oneProduct')
                ->withProduct($product)
                ->withCategories(ProductClass::all())
                ->withName('product');
        } else {
            return View::make('product')
                ->withTitle('產品介紹')
                ->withProducts(Product::orderBy('id', 'DESC')->paginate(12))
                ->withCategories(ProductClass::all())
                ->withName('product');
        }
    }
    public function getProductclass($id=0)
    {
        $category = ProductClass::findOrFail($id);
        return View::make('product')
            ->withTitle($category->title)
            ->withProducts($category->products()->paginate(12))
            ->withCategories(ProductClass::all())
            ->withName('product');
    }

    public function getAbout()
    {
        return View::make('about', array('name' => 'about'));
    }

    public function getActivity($id=null)
    {
        if ($id) {
            return View::make('oneActivity')
                ->withActivity(Activity::findOrFail($id))
                ->withCategories(ActivityClass::all())
                ->withName('activity');

        }else {
            return View::make('activity')
                ->withTitle("活動紀錄")
                ->withActivities(Activity::orderBy('viewed', 'DESC')->paginate(10))
                ->withCategories(ActivityClass::all())
                ->withName('activity');
        }
    }
    public function getActivityclass($id=0)
    {
        $class = ActivityClass::findOrFail($id);
        return View::make('activity')
            ->withTitle($class->title)
            ->withActivities($class->articles()->paginate(10))
            ->withCategories(ActivityClass::all())
            ->withName('activity');
    }

}
