<?php
//class UserController extends BaseController {
class UserController extends MyadminUserController {

    public function getManage()
    {
        $users = array();
        $users = DB::table('users')->get();
        return View::make('user')->withUsers($users)
            ->with('_CONST', $this->_CONST);
    }

    public function getManager()
    {
        $managers = array();
        $managers = DB::table('administrators')->get();
        return View::make('manager')->withManagers($managers)->with('_CONST', $this->_CONST);
    }

    public function getCreateUser()
    {
        return View::make('createUser')
            ->with('_CONST', $this->_CONST);
    }

    public function getUpdateUser($id = NULL)
    {
        if($id)
            return View::make('updateUser')->withId($id)
                ->with('_CONST', $this->_CONST);
        else
            return Redirect::back();
    }

    public function getMemberlist($level)
    {
	if($level == 1)
	{
		$users = array();
	        $users = DB::table('users')->where('level','=','種子帳戶')->get();
        	return View::make('user')->withUsers($users)->withId('0')
            		->with('_CONST', $this->_CONST);
	}
	else if($level == 2)
	{
	        $users = array();
        	$users = DB::table('users')->where('level','=','一般帳戶')->get();
	        return View::make('user')->withUsers($users)->withId('1')
        	    ->with('_CONST', $this->_CONST);
	}
	else
	{
	        $users = array();
	        $users = DB::table('users')->get();
        	return View::make('user')->withUsers($users)->withId('-1')
            		->with('_CONST', $this->_CONST);
	}
    }

    public function getFollow($id)
    {
        $follows = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->join('users', 'users.id', '=', 'myadmin_follows.user_id')
                ->where('myadmin_follows.blogger_id', DB::raw($id))
                ->orderBy("myadmin_follows.created_at", 'desc')
                ->select(DB::raw('users.name as user_name
                , users.email as email, users.img_path as img_path'))->get();


        $blogger = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->where('myadmin_follows.blogger_id', DB::raw($id))
            ->get();

        return View::make('front.follow')
            ->withFollows($follows)
            ->withBlogger($blogger[0]);
    }

    public function getDetail($id)
    {

        $bloggers = Follow::join('bloggers', 'bloggers.id', '=', 'myadmin_follows.blogger_id')
            ->where('myadmin_follows.user_id', DB::raw($id))
            ->get();

	$user=array();
	$user=DB::table('users')->where('id',$id)->first();
	//return View::make('detailUser')
	return View::make('user_detail')
		->withBloggers($bloggers)
		->withUser($user)
		->with('_CONST', $this->_CONST);
    }

// 會員 更改資料
    public function postUseredit()
    {
        $salt = Config::get('Myadmin::admin.salt');
        $userInput = Input::all();
	$info = DB::table('users')->where('id',Session::get('userId'))->first();
	$user_name = $info ->name;
	$img_path = $info->img_path;
	$password = $info->password;
	$chk_passwd = 0;
        if(Input::hasFile('img_path'))
	{
		$dest = img_upload_path();
                $file = Input::file('img_path');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $img_path =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
	}
        if(Input::has('user_name'))
                $user_name = $userInput['user_name'];
        if(Input::has("pre_password"))
	{
                $pre_password =crypt($userInput['pre_password'], $salt);
		$chk_passwd = DB::table('users')->where('id',Session::get('userId'))->where('password',$pre_password)->count();
		$password = $pre_password;
	}
        if(Input::has('new_password') && Input::has('check_password'))
                if( Input::get('new_password') == Input::get('check_password'))
		{
			if($chk_passwd >0)
				$password = crypt($userInput['new_password'], $salt);
			else
				return Redirect::back()->withErrors("密碼錯誤");	
		}
		else
			return Redirect::back()->withErrors("密碼驗證錯誤");
	DB::table('users')->where('id',Session::get('userId'))
				->update(array(
					'name'=>$user_name,
					'password'=>$password,
					'img_path'=>$img_path,
				));
	return Redirect::back();
    }	

    public function getSendPasswd($id)
    {
	$member=array();
        $member=DB::table('administrators')->where('id',$id)->first();
	$newPasswd = substr(md5(time()),-8);
	$salt = Config::get('Myadmin::admin.salt');
	 DB::table('administrators')->where('id',$id)
                           ->update(array(
                                'password'=> crypt($newPasswd, $salt),));
	// I'm creating an array with user's info but most likely you can use $user->email or pass $user object to closure later
	$user = array(
		'email'=>$member->email,
		'name'=>$member->username
	);

	// the data that will be passed into the mail view blade template
	$data = array(
		'detail'=>'Your awesome detail here',
		'name'	=> $user['name'],
		'password' =>$newPasswd
	);

	// use Mail::send function to send email passing the data and using the $user variable in the closure
	Mail::send('emails.welcome', $data, function($message) use ($user)
	{
	  //$message->from('jackwang0919@gmail.com', 'jackwang0919');
	  $message->to($user['email'], $user['name'])->subject('LOOKNOW，登入新的密碼');
	});
	return Redirect::back()->withErrors("Success!");
    }
/////add Manager account

    public function postAddManager()
    {
	$rules = [
                'account'=>'required | unique:users',
                'password'=>'required',
                'authority'=>'required',
		'status'=>'required'];

        $validation = Validator::make(Input::all(),$rules);
        if($validation->fails())
        {
                return Redirect::back()->withErrors($validation)->withInput();
        }
        try{
                DB::table('administrators')->insert(array(
                    array(
                        'account'=>Input::get('account'),
                        'password'=>Input::get('password'),
                        'level'=>Input::get('authority'),
                        'created_at'=>Input::get('register-time'),
                        'email'=>Input::get('email'),
			'username'=>Input::get('account')),
                ));

                $id = Session::get('id');
                OperatorLog::saveItem($id, "新增使用者 " . Input::get('accounte'));
            }
            catch(Exception $e)
            {
                //return Redirect::back()->withErrors('Error!!')->withInput();
                return Redirect::back()->withErrors($e)->withInput();
            }
            return Redirect::to('admin/user/manager');
    }
////
//////create fb login account
   public function getFblogin($profile)
   {
        $profile = explode(",",$profile);
	if(!(isset($profile[3])))
		$profile[3]="";

        $chk_count= DB::table('users')
            ->where('account','=',$profile[1])
            //->where('email','=',$profile[3])
            ->count();

	  if($chk_count == 0){
            try{
                DB::table('users')->insert(array(
                    array(
                        'register_time'=>date('Y-m-d H:i'),
                        'login_type'=>"Facebook",
                        'status'=>'正常',
                        'authority'=>'一般',
			'img_path'=>'https://graph.facebook.com/'.$profile[1].'/picture?type=large',
                        'email'=>$profile[3],
                        'account'=>$profile[1],
                        'name'=>$profile[0],
                        'gender'=>'male',//$profile[2],
                        'phone'=>"N",
			'comment_is_available'=>'1',
                        'level'=>"種子帳戶"),
                ));

            }
            catch(Exception $e)
            {
                return Redirect::back()->withErrors($e);
            }
        }
        $account= DB::table('users')
            ->where('account','=',$profile[1])
            ->first();
	Session::put('userId',$account->id);
	Session::put('userName',$account->name);
        $articles = DB::table('myadmin_articles')->get();
	$articlesclass = DB::table('myadmin_article_classes')->get();

        return Redirect::back();
   }



////

    public function postAddSeedUser()
    {
	$rules = [
		'email'=>'required | unique:users',
		'name'=>'required',
		'phone'=>'required'];

	$validation = Validator::make(Input::all(),$rules);
	if($validation->fails())
	{
		return Redirect::back()->withErrors($validation)->withInput();
	}
	try{
                DB::table('users')->insert(array(
                    array(
                        'register_time'=>Input::get('register-time'),
                        'login_type'=>Input::get('login-type'),
			'status'=>Input::get('status'),
			'authority'=>Input::get('authority'),
                        'email'=>Input::get('email'),
                        'name'=>Input::get('name'),
                        'phone'=>Input::get('phone'),
			'level'=>"種子帳戶"),
                ));

                $id = Session::get('id');
                OperatorLog::saveItem($id, "新增種子會員 " . Input::get('accounte'));
            }
            catch(Exception $e)
            {
		//return Redirect::back()->withErrors('Error!!')->withInput();
		return Redirect::back()->withErrors($e)->withInput();
            }
            return Redirect::to('admin/user/manage');
		
    }
    public function postAddUser()
    {
        //validation
        $rules = [ 
            'account'=>'required|unique:users',
            'userPassword'=>'required',
            'userId'=>'required|unique:users,identification',
            'birthday'=>'required',
            'phone'=>'required',
            'email'=>'required',
            'address'=>'required',
	    'name'=>'required'];

        $validation = Validator::make(Input::all(),$rules);

        if($validation->fails()) {
            return Redirect::back()->withErrors($validation)
                ->withInput();
        }

        //Add new user info 
        $salt = Config::get('Myadmin::admin.salt');
        $parent_id = NULL;
        $parent_mail=NULL;
        $chk_count= DB::table('users')->where('email',Input::get('parentId'))->count();
        $chk= DB::table('users')->where('email',Input::get('parentId'))->first();
        if($chk_count <= 0 && Input::has('parentId')) {
            return Redirect::back()->withErrors('parent mail Error!!')->withInput();
        } else {
            if($chk_count > 0){
                $parent_id = $chk->id;
                $parent_mail = $chk->email;
            }
		$is_available = 0;
		if(Input::get('status')=='正常')
			$is_available =1;
            $img_path = " ";
            if(Input::hasFile('image')) {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                $r = rand(1,999);
                $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                $img_path =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
            }

            try {
           
                DB::table('users')->insert(array(
                    array(
                        'account'=>Input::get('account'),
                        'password'=> crypt(Input::get('userPassword'), $salt),
                        'email'=>Input::get('email'),
                        'phone'=>Input::get('phone'),
                        'identification'=>Input::get('userId'),
                        'birthday'=>Input::get('birthday'),
                        'address1'=>Input::get('address'),
                        'parent_id'=> $parent_id,
                        'level'=>'一般帳戶',
                'register_time'=>Input::get('register-time'),
                'login_type'=>Input::get('login-type'),
                'authority'=>Input::get('authority'),
                'status'=>Input::get('status'),
                'is_available'=>$is_available,
                'comment_is_available'=>'1',
                'name'=>Input::get('name'),
                'img_path'=>$img_path,
                'gender'=>Input::get('gender')),
                    ));

                $id = Session::get('id');
                OperatorLog::saveItem($id, "新增使用者 " . Input::get('account'));
            } catch(Whoops\Handler\PrettyPageHandler $e) {
                list($dd,$mm,$yyyy) = explode('/',$cnt_birthday);
                $birthday = $yyyy . '-' . $mm . '-' . $dd;
                Input::replace(array("birthday" => $birthday));
                return Input::get("birthday");
                return Redirect::back()->with('message',$e)->withInput();
            }
            return Redirect::to('admin/user/manage');
        }
    }


    public function postUpdate($id =NULL)
    {
        $salt = Config::get('Myadmin::admin.salt');
        $parent_id = NULL;
        $parent_count= DB::table('users')->where('email',Input::get('parentId'))->count();
        $parent= DB::table('users')->where('email',Input::get('parentId'))->first();
        if($parent_count>0)
            $parent_id = $parent->id;	
        else
            $prent_id = NULL;


        if(!(Input::has('userPassword')) && !(Input::has('userNewPassword')))	
        {
            $chk_count= DB::table('users')->where('email',Input::get('parentId'))->count();
            $chk= DB::table('users')->where('email',Input::get('parentId'))->first();
            if($chk_count <= 0 && Input::has('parentId'))
                return Redirect::back()->withId($id)->withErrors('Parent Mail 有誤!')->withInput();
            else
            {
                if($parent_id != NULL)
                {
                    DB::table('users')->where('id',Input::get('id'))
                        ->update(
                            array(
                                'account'=>Input::get('account'),
                                //'password'=> crypt(Input::get('userPassword'), $salt),
                                'email'=>Input::get('email'),
                                'phone'=>Input::get('phone'),
                                'identification'=>Input::get('userId'),
                                'birthday'=>Input::get('birthday'),
                                'address1'=>Input::get('address'),
                                'parent_id'=>$parent_id,
                            ));

                    $id = Session::get('id');
                    OperatorLog::saveItem($id, "編輯使用者 " . Input::get('account'));
                    return Redirect::to('admin/user/manage')->with('message','Update success!');
                }
                else
                    return Redirect::back()->withId($id)->withErrors('Parent Mail 有誤!');

            }
        }
        else      //輸入錯誤密碼，會有錯誤，無法正常執行！！！！
        {
            $prepasswd = crypt(Input::get('userPassword'), $salt);
            $chkUpdate= DB::table('users')->where('account',Input::get('account'))->where('password',$prepasswd)->count();
            if($chkUpdate > 0)
            {
                if(Input::has('userNewPassword'))
                {
                    if(Input::has('userChkPassword'))
                    {
                        if(Input::get('userNewPassword') != Input::get('userChkPassword'))
                            return Redirect::back()->withId($id)->withErrors('新密碼與確認碼有誤')->withInput();
                    }
                    else
                        return Redirect::back()->withId($id)->withErrors('請再次輸入確認碼')->withInput();


                    DB::table('users')->where('id',Input::get('id'))
                        ->update(
                            array(
                                'account'=>Input::get('account'),
                                'password'=> crypt(Input::get('userNewPassword'), $salt),
                                'email'=>Input::get('email'),
                                'phone'=>Input::get('phone'),
                                'identification'=>Input::get('userId'),
                                'birthday'=>Input::get('birthday'),
                                'address1'=>Input::get('address'),
                                'parent_id'=>$parent_id,
                            ));
                    return Redirect::to('admin/user/manage')->with('message','Update success!');
                }
                else{
                    echo "輸入新密碼";
                    return Redirect::back()->withId($id)->withErrors('請輸入新密碼')->withInput();
                    //return Redirect::to('admin/user/updateUser/'.$id)->withErrors('請輸入新密碼');
                }
            }
            else {
                echo "密碼錯誤";
                return Redirect::back()->withId($id)->withErrors('舊密碼有誤')->withInput();
                //return Redirect::to('admin/user/updateUser')->withErrors('舊密碼有誤');
            }
        }
    } 


    public function postDeleteUser()
    {
	$check_authority = DB::table('users')->where('id',Input::get('id'))->first();
	$authority =$check_authority->is_available;
	//DB::table('users')->where('id','=',Input::get('id'))->delete();
	if($authority == 1)
	{
		DB::table('users')->where('id','=',Input::get('id'))->update(array('is_available'=>'0'));
        $id = Session::get('id');
        $user = User::find(Input::get('id'));
        OperatorLog::saveItem($id, "停權 使用者 " . $user->account);
		$authority = 0;
	}
	else
	{
		DB::table('users')->where('id','=',Input::get('id'))->update(array('is_available'=>'1'));
        $id = Session::get('id');
        $user = User::find(Input::get('id'));
        OperatorLog::saveItem($id, "復權 使用者 " . $user->account);
		$authority = 1;
	}
	return Redirect::to('admin/user/manage')->withAuthority($authority);//->with('message','success!');
    }

    public function getDeleteCommentator($userId)
    {
	$check_authority = DB::table('users')->where('id',$userId)->first();
        $authority =$check_authority->comment_is_available;
        if($authority == 1)
        {
                DB::table('users')->where('id','=',$userId)->update(array('comment_is_available'=>'0'));
        	$id = Session::get('id');
	        $user = User::find($userId);
		OperatorLog::saveItem($id, "封鎖 留言者 " . $user->account);
                $authority = 0;
        }
        else
        {
                DB::table('users')->where('id','=',$userId)->update(array('comment_is_available'=>'1'));
	        $id = Session::get('id');
        	$user = User::find($userId);
	        OperatorLog::saveItem($id, "解除封鎖 留言者 " . $user->account);
                $authority = 1;
        }
	return Redirect::to('admin/user/manage');//->withErrors('success!');
    }

    public function getDeleteAllComments($userId)
    {
	DB::table('article_comments')->where('commender_id',$userId)->delete();
	return Redirect::back();
    }




///////////////////////////////////////////////////API
    public function getLogin()
    {
        return View::make('user_login');
    }

    public function getLogout()
    {
        //清除session
        // Session::flush('token');
        Session::forget('isLogin');
        return Redirect::to('admin')->with('message','Logout success!');
    }

    public function getAccountLogout()
    {
        Session::forget('userId');
        Session::forget('userName');
        return Redirect::to('admin/front/');
    }

    public function postUserAccount()
    {
        $salt = Config::get('Myadmin::admin.salt');
        $passwd = crypt(Input::get('password'), $salt);
	$chk_account = DB::table('users')->where('account',Input::get('UserAccount'))->where('password',$passwd)->count();
	if($chk_account > 0){
	        $user = DB::table('users')->where('account',Input::get('UserAccount'))->where('password',$passwd)->first();
		if($user->is_available){
			Session::put('userId',$user->id);
			Session::put('userName',$user->name);

		        return Redirect::back();
		}
		else
			return Redirect::back()->withErrors('權限問題')->withInput();
	}
	else
	{
        	return Redirect::back()->withErrors('帳號密碼有誤！！')->withInput();
	}
    }
}
