<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
    {
        if(!Schema::hasTable('users')) {
            //
            Schema::create('users', function(Blueprint $table)
            {
                $table->increments('id');
                $table->string('introduce_id')->nullable();
                $table->integer('parent_id')->unsigned()->nullable();
                $table->enum('login_type', array('Looknow','Facebook'));
                $table->string('email')->nullable();
                $table->string('account');
                $table->string('password')->nullable();
                $table->string('register_time')->nullable();
                $table->string('last_login_time')->nullable();
                $table->enum('status', array('正常','停權'));
                $table->enum('authority', array('一般','特殊'));
                $table->string('name');
                $table->string('img_path');
                $table->string('gender')->nullable();
                $table->date('birthday')->nullable();
                $table->string('phone', 20);
                $table->string('address1', 255)->nullable();
                $table->string('address2', 255)->nullable();
                $table->string('address3', 255)->nullable();
                $table->boolean('is_available')->default(true);
                $table->boolean('comment_is_available')->default(true);
                $table->string('identification')->unique()->nullable();
                $table->enum('level', array('種子帳戶','一般帳戶'));
                $table->timestamps();

                $table->unique(array('email','account'));
                $table->foreign('parent_id')->references('id')->on('users')->onDelete('set null');
            });
        }

        if(!Schema::hasTable('records')) {
            Schema::create('records', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('user_id')->unsigned();
                $table->integer('month_1')->default(0);
                $table->integer('month_2')->default(0);
                $table->integer('month_3')->default(0);
                $table->integer('month_4')->default(0);
                $table->integer('month_5')->default(0);
                $table->integer('month_6')->default(0);
                $table->integer('month_7')->default(0);
                $table->integer('month_8')->default(0);
                $table->integer('month_9')->default(0);
                $table->integer('month_10')->default(0);
                $table->integer('month_11')->default(0);
                $table->integer('month_12')->default(0);
                $table->integer('bonus_money')->default(0);
                $table->integer('bonus_used')->default(0);
                $table->integer('money_used')->default(0);
                
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            });
        }
		//
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		//
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('records');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('users');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
	}

}
