<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
        //
        if(!Schema::hasTable('transactions')) {
            Schema::create('transactions', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('order_code');
                $table->integer('money');
                $table->integer('bonus_money');
                $table->string('address');
                $table->string('products_json');
                $table->string('mail');
                $table->integer('amount');
                $table->string('detail');
                $table->enum('status', array('尚未付款','付款完成','已出貨','訂單完成','取消訂單','退換貨處理中'));
                $table->timestamp('date');
                $table->timestamps();
                
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		//
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('transactions');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
	}

}
