<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdministratorsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		//
        if(!Schema::hasTable('administrators')) {
            Schema::create('administrators', function(Blueprint $table)
            {
                $table->increments('id');
                $table->string('account')->unique();
                $table->string('password');
                $table->string('username');
                $table->string('email');
                $table->enum('level', array('最高管理員','退換貨人員','會計人員','客服人員'));
                $table->timestamps();
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		//
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('administrators');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
	}

}
