<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBonusTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('bonuses')) {
            Schema::create('bonuses', function(Blueprint $table)
        {
            $table->increments('id');
            $table->integer('transaction_id')->unsigned()->nullable();
            $table->integer('user_id')->unsigned();
            $table->integer('from_id')->unsigned()->nullable();
            $table->double('bonus');
            $table->text('description');
            $table->enum('type', array('門市','介紹','分紅','兌現','紅利使用'));
            $table->timestamp('date');
            $table->timestamps();

            $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('from_id')->references('id')->on('users')->onDelete('cascade');
        });
        }

        if(!Schema::hasTable('bonuses_queues')) {
            Schema::create('bonuses_queues', function(Blueprint $table)
        {
            $table->increments('id');
            $table->integer('transaction_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->integer('from_id')->unsigned()->nullable();
            $table->double('bonus');
            $table->enum('type', array('門市','介紹','分紅','兌現','紅利使用'));
            $table->timestamp('date');
            $table->timestamps();

            $table->foreign('transaction_id')->references('id')->on('transactions');
            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('from_id')->references('id')->on('users')->onDelete('set null');;
        });
        }

        if(!Schema::hasTable('bonuses_logs')) {
            Schema::create('bonuses_logs', function(Blueprint $table)
        {
            $table->increments('id');
            $table->integer('admin_id')->unsigned();
            $table->integer('bonus_queue_id')->unsigned();
            $table->double('bonus');
            $table->text('error_reason');
            $table->enum('status', array('已兌現','未兌現','失敗'));
            $table->string('bank_account');
            $table->timestamp('date');
            $table->timestamps();

            $table->foreign('admin_id')->references('id')->on('administrators');
            $table->foreign('bonus_queue_id')->references('id')->on('bonuses_queues');
        });
        }

        if(!Schema::hasTable('bonuses_categories')) {
            Schema::create('bonuses_categories', function(Blueprint $table)
        {
            $table->increments('id');
            $table->string('code')->unique();
            $table->string('category');
            $table->float('value'); // as retail-value
            $table->float('retail_value');
            $table->float('introduction_value');
            $table->float('bonus_value');
            $table->timestamps();
        });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bonuses');
        Schema::dropIfExists('bonuses_categories');
        Schema::dropIfExists('bonuses_logs');
        Schema::dropIfExists('bonuses_queues');
        //
    }

}
