<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{

        if(!Schema::hasTable('products_categories')) {
            Schema::create('products_categories', function(Blueprint $table)
            {
                $table->increments('id');
                $table->string('name');
                $table->boolean('show');
                $table->timestamps();
            });
        }
        
        if(!Schema::hasTable('products')) {
            Schema::create('products', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('category_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->boolean('publish');
                $table->string('title');
                $table->string('subheading');
                $table->integer('price');
                $table->integer('selling_price');
                $table->text('description');
                $table->string('format');
                $table->string('img_path');
                $table->string('shops_id');
                $table->integer('views');
                $table->string('tag_1');
                $table->string('tag_2');
                $table->string('tag_3');
                $table->string("money");
                $table->enum("is_available", array('上架','下架'));
                $table->string('official_url');
                $table->timestamp("start_date");
                $table->timestamps();

                $table->foreign('category_id')->references('id')->on('products_categories')->onDelete('cascade');
            });
        }
        
        if(!Schema::hasTable('shops')) {
        Schema::create('shops', function(Blueprint $table)
		{
			$table->increments('id');
			$table->string('name');
			$table->string('region');
			$table->string('position_x');
			$table->string('position_y');
			$table->text('description');
			$table->integer('view');
			$table->string('address');
			$table->timestamps();
            
        });
        }

        if(!Schema::hasTable('products_detail')) {
            Schema::create('products_detail', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('product_id')->unsigned();
                $table->string('img_title');
                $table->string('image');
                $table->string('img_description');
                $table->timestamps();
                
                $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            });
        }

        if(!Schema::hasTable('brands')) {
            Schema::create('brands', function(Blueprint $table)
            {
                $table->increments('id');
                $table->string('name');
                $table->string('description');
				$table->string('facebook_url');
				$table->string('instagram_url');
				$table->string('youtube');
				$table->string('img_path');
				$table->string('photo_path');
				$table->string('buynow');
				$table->string('location');
        		        $table->string('url');
				$table->integer('follow')->default(0);
				$table->integer('like')->default(0);
				$table->integer('post')->default(0);
                $table->timestamps();
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('products_categories');
		Schema::dropIfExists('products');
		Schema::dropIfExists('products_detail');
		Schema::dropIfExists('shops');
		Schema::dropIfExists('records');
		Schema::dropIfExists('users');
		Schema::dropIfExists('brands');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
		//
	}

}
