<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionsReturnTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		//
		Schema::create('transactions_return', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('transaction_id')->unsigned();
			$table->integer('admin_id')->unsigned();
			$table->string('image1');
			$table->string('image2');
			$table->string('image3');
			$table->string('description');
			$table->enum('status', array('已換','待換','已退貨'));
			$table->timestamp('date');
			$table->timestamps();
			
			$table->foreign('transaction_id')->references('id')->on('transactions');
			$table->foreign('admin_id')->references('id')->on('administrators');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		//
		Schema::dropIfExists('transactions_return');
	}

}
