<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOperatorLogTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('operator_log', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('admin_id')->unsigned()->nullable();
			$table->string('operator');
			$table->timestamps();
			
			$table->foreign('admin_id')->references('id')->on('administrators')->onDelete('cascade');
		});

                Schema::create('action_log', function(Blueprint $table)
                {
                        $table->increments('id');
                        $table->string('user_id');
			$table->enum('action', array('LIKE','FOLLOW','SHARE','COLLECT','COMMENTS','BROWSE','goWeb','goStore','goShop'));
			$table->enum('object', array('ARTICLE','LOOKER','MODEL_KAI','MODEL_E','BRAND'));
                        $table->string('object_id');
                        $table->string('blogger_id')->nullable();
                        $table->timestamps();

                });

	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		//
		Schema::dropIfExists('operator_log');
		Schema::dropIfExists('action_log');
	}

}
