<?php

class DatabaseSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Eloquent::unguard();

        DB::table('bonuses')->delete();
        DB::table('bonuses_categories')->delete();
        DB::table('transactions')->delete();
//        DB::table('products_detail')->delete();

        $this->call('UserTableSeeder');
        $this->call('AdministratorTableSeeder');
        $this->call('BonusesTableSeeder');
		$this->call('BrandTableSeeder');
        $this->call('ProductCategoryTableSeeder');
        $this->call('ProductTableSeeder');
        $this->call('TransactionsTableSeeder');
        $this->call('ShopsTableSeeder');
        $this->call('RecordsTableSeeder');
        $this->call('OperatorLogTableSeeder');
        $this->call('ArticleSeeder');
        $this->call('ArticleClassSeeder');
        $this->call('BloggersSeeder');
        $this->call('FollowSeeder');
        $this->call('BloggerLikeSeeder');
		$this->call('HomeSeeder');
    }
}

class BloggerLikeSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('myadmin_blogger_like')->delete();
        $time = new DateTime;
        
        $user = User::firstOrFail();
        $blogger= BloggerUser::firstOrFail();

        $class = array(
            array(
                "user_id" => $user->id,
                "blogger_id" => $blogger->id,
                'created_at' => $time,
                'updated_at' => $time
            )
        );
        DB::table('myadmin_blogger_like')->insert($class);

        $count = BloggerLike::where('blogger_id', $blogger->id)->count();
        $blogger = BloggerUser::find($blogger->id);
        $blogger->like_num = $count;
        $blogger->save();
    }
}

class FollowSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('myadmin_follows')->delete();
        $time = new DateTime;
        
        $user = User::firstOrFail();
        $blogger= BloggerUser::firstOrFail();

        $class = array(
            array(
                "user_id" => $user->id,
                "blogger_id" => $blogger->id,
                'created_at' => $time,
                'updated_at' => $time
            )
        );
        DB::table('myadmin_follows')->insert($class);

        $count = Follow::where('blogger_id', $blogger->id)->count();
        $blogger = BloggerUser::find($blogger->id);
        $blogger->follow_num = $count;
        $blogger->save();
    }
}

class BloggersSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('bloggers')->delete();
        $time = new DateTime;

        $class = array(
            array(
                'name' => "羅志祥",
                'description' => "是台灣華語流行音樂男歌手、節目主持人、演員，外號「小豬」。私下與好友組成Party Boys（羅志祥、小葦、紅毛、山姆及軟軟）。於1996年以團體「四大天王」出道，後與歐漢聲組成羅密歐，解散後轉型為綜藝節目主持人，獨特的主持風格受到大眾喜愛，2003開始推出個人專輯，所有唱片於亞洲的銷量逾700萬張，並且連續四年獲得台灣銷售總冠軍（2010-2013年）。2006年自創品牌「STAGE」，成功進軍潮流界，先後在台灣、香港及新加坡開設分店。偶像是周星馳、Michael Jackson、日本巨星木村拓哉、香港巨星、四大天王中的郭富城和劉德華，以及台灣男子偶像組合小虎隊和四小天王中的林志穎。",
                'Facebook_url' => "https://www.facebook.com/IsShow",
                'Instagram_url' => "",
                'Youtube_url' => "",
                'photo' => "https://upload.wikimedia.org/wikipedia/zh/thumb/c/c3/%E7%BE%85%E5%BF%97%E7%A5%A5_%E6%BD%AE%E7%94%B7%E6%AD%A3%E5%82%B3.jpg/451px-%E7%BE%85%E5%BF%97%E7%A5%A5_%E6%BD%AE%E7%94%B7%E6%AD%A3%E5%82%B3.jpg",
		'image' => "http://www.horien-eyewear.com/img/banner7.jpg",
		'buy_now' => "",
		'location' => "",
		'website' => "",
                'created_at' => '2015-09-01',
                'updated_at' => $time
            ),
            array(
                'name' => "小小兵",
		'description' => "《小小兵》（英語：Minions）是一部於2015年上映的美國3D電腦動畫喜劇電影，是2010年與2013年上映的電影《神偷奶爸》、《神偷奶爸2》的外傳作品，由布萊>    恩·林奇編劇，由皮耶·考芬與凱爾·巴爾達執導，且由克里斯·梅勒丹德利與珍娜·海莉製作[4]。由喬·漢姆和珊卓·布拉克參與配音演出。此片以小小兵為主要角色，並於6月18日在馬來西亞和新加坡、7>    月9日在臺灣和香港、7月10日在美國上映。",
                'Facebook_url' => "https://www.facebook.com/TheMinions2015?fref=ts",
		'Instagram_url' => "",
                'Youtube_url' => "https://www.youtube.com/watch?v=WlfIYn8-1pI",
		'photo' => "http://www2.cool-style.com.tw/cool/2015/07/10477BANN-1.jpg",
		'image' => "http://resource.holyshare.com.tw/uploads/article/600x0/1435212931wC0_1.jpg",
		'buy_now' => "https://tw.search.mall.yahoo.com/search/mall/product?p=%E5%B0%8F%E5%B0%8F%E5%85%B5&act=srpa",
		'location' => "https://www.google.com.tw/maps/place/%E5%B0%8F%E5%B0%8F%E5%85%B5%E6%A8%A1%E5%9E%8B%E7%8E%A9%E5%85%B7%E5%BA%97/@25.014235,121.517492,17z/data=!3m1!4b1!4m2!3m1!1s0x3442a9eb1b3bb363:0xa88d681e0c4fee90",
		'website' => "https://zh.wikipedia.org/wiki/%E5%B0%8F%E5%B0%8F%E5%85%B5",
                'created_at' => '2015-09-01',
                'updated_at' => $time
            ),

        );
        DB::table('bloggers')->insert($class);
    }
}

class ArticleClassSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('myadmin_article_classes')->delete();
        $time = new DateTime;
        
        $admins = Administrator::all();

        $class = array(
            array(
                'title' => "包包",
                'is_available' => 1
            ),
            array(
                'title' => "影劇",
                'is_available' => 1
            ),
            array(
                'title' => "LOOKNOW",
                'is_available' => 1
            ),
            array(
                'title' => "MAKE",
                'is_available' => 1
            ),
            array(
                'title' => "OUTFIT",
                'is_available' => 1
            ),
            array(
                'title' => "FOOD",
                'is_available' => 1
            ),
            array(
                'title' => "TRAVEL",
                'is_available' => 1
            ),
            array(
                'title' => "SPORT",
                'is_available' => 1
            )
        );
        DB::table('myadmin_article_classes')->insert($class);
    }
}
class ArticleSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('myadmin_articles')->delete();
        $time = new DateTime;
        
        $admins = Administrator::all();
        $cate= ArticleClass::firstOrFail();
        $blogger= BloggerUser::firstOrFail();
        $product= Product::firstOrFail();

        $article = array(
            array(
                'title' => "pollo pavone 到底是什麼？",
                'category' => $cate->id,
                'tag1' => "機車",
                'tag2' => "美甲",
                'tag3' => "跳舞",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "http://4.bp.blogspot.com/-erKu6K9mQ6c/VE5GBUGnCeI/AAAAAAAAAwg/jdsV01UjDPM/s1600/chickenpeacockcostumes.jpg",
                'youtube_url' => "https://www.youtube.com/watch?v=u5QjZOXDw4o",
                'description' => "話說，PTT批踢踢的熱門用語近來已經升級，邁向國際化，不是數字、諧音了，也不是英文了，是......義大利文。a安捏？水星人怎麼發現這個詭異現象正在蔓延的呢？故事是這樣開端的.....水星人大頭怪是一位棒球迷。正當他在家度過連假最後一天，收看中華職棒熱身賽轉播的時候，他也順勢的打開PTT的棒球版，就發現，一連串關於pavone或是pollo的留言。正當納悶之時，進入八卦版一看，整個2015年3月1日的Gossiping版儼然變成是個pollo pavone版。到底這個昏睡的早上發生了什麼事情？每篇留言都有這兩個詞。甚至開始有些標題就是：某某人是pollo還是pavone？人生沒有XX就是pollo嗎？甚至一篇文章po出，一定會有「pollo」或是「pavone」的留言或評語。到底，pollo跟pavone是什麼啦？",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            ),
            array(
                'title' => "第一次說小小兵話就上手！一張圖快速學會小小兵語",
                'category' => $cate->id,
                'tag1' => "水果",
                'tag2' => "語言",
                'tag3' => "香蕉",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "http://stars.udn.com/starimages/slide/213834/M_213842-DM2_Minion_Bob_005.jpg",
                'youtube_url' => "https://www.youtube.com/watch?v=WlfIYn8-1pI",
                'description' => "由環球影業以及Illumination娛樂公司出品的《小小兵》故事起源於盤古開天時期，剛開始只是一個黃色的有機體，隨著時間漸漸演化成小小兵團，他們的存在目的就是要服侍當代最兇惡的主人，然而從T. Rex 恐龍，埃及法老王，拿破崙甚至是德古拉，小小兵總是不停的失敗了-到最後小小兵們發現已經沒有可以服侍的主人，從此開始鬱鬱寡歡，甚至逐漸凋零。這時其中的一隻小小兵—凱文他有個偉大的計畫，就是帶著他的麻吉—大胃王史都華還有膽小的蘿蔔，挺身而出踏上尋找新主人的冒險旅程…",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            ),
            array(
                'title' => "感受英倫搖滾的魅力",
                'category' => $cate->id,
                'tag1' => "test1",
                'tag2' => "test2",
                'tag3' => "香蕉",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "https://encrypted-tbn2.gstatic.com/images?q=tbn:ANd9GcT3-Hn1fvd7KlZV0Z5s9roYV7yLD5wi8vb_xlYxW2N6cDfQtkmR",
                'youtube_url' => "https://www.youtube.com/watch?v=WlfIYn8-1pI",
                'description' => "model test test testMarshall來自英國倫敦，為製造搖滾音箱的廠商，在各種演唱會上都可以見到它的身影，如今Marshall將其音箱技術凝聚在耳罩耳機上，黑色皮革的頭帶配上金色logo，內側也有金屬製名牌，單體前端則使用常見於音箱的編織物，厚實的沙發皮革耳罩也讓配戴更為舒適，獨特英系調音聆聽絕對的感受。",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            ),
            array(
                'title' => "同時打 4 台神奇寶貝的男人..",
                'category' => $cate->id,
                'tag1' => "test1",
                'tag2' => "test2",
                'tag3' => "香蕉",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "https://pbs.twimg.com/media/CHwM9ChUkAE2CjP.jpg",
                'youtube_url' => "https://video.xx.fbcdn.net/hvideo-xfp1/v/t42.1790-2/11893443_10153140781558937_132719986_n.mp4?efg=eyJybHIiOjM0NywicmxhIjo1MTJ9&rl=347&vabr=193&oh=9c02b4aef5604637517c5782fef0136e&oe=55D38849",
                'description' => "model test test test上面兩台用錢卡住...單純只是走步數增加親近度= =下面兩台才是真正再動作....",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            ),
            array(
                'title' => "模仿達人 BdotAdot5 最新力作－模仿",
                'category' => $cate->id,
                'tag1' => "test1",
                'tag2' => "test2",
                'tag3' => "香蕉",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "https://encrypted-tbn1.gstatic.com/images?q=tbn:ANd9GcShQVYMwQTg9-HFgICsjFAfRm8DH5YjaxmSqRBEl0gJWlkCegcI",
                'youtube_url' => "https://video.xx.fbcdn.net/hvideo-xaf1/v/t42.1790-2/11829854_10153149482345840_2072287638_n.mp4?efg=eyJybHIiOjY4NSwicmxhIjo1MTJ9&rl=685&vabr=381&oh=541b5e1e4635dd7468fdfa33ab694e7e&oe=55D38962",
                'description' => "model test test test我看了大約十次切入的時段 他似乎走步了 大家怎看 兩腳站地 接著右腳探步(表示左腳為軸)..",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            ),
            array(
                'title' => "開發APP",
                'category' => $cate->id,
                'tag1' => "test1",
                'tag2' => "test2",
                'tag3' => "香蕉",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "http://cdn2.ettoday.net/images/968/d968367.jpg",
                'youtube_url' => "https://www.youtube.com/watch?v=WlfIYn8-1pI",
                'description' => "model test test testLINE、Evernote、Candy Crash、Angry Birds這些耳熟能詳的APP創造了無數的熱潮與商機，人人都可以藉著APP撰寫自己的神話，靠著APP致富不只是白日夢。TibaMe APP線上課程，讓你成為下一個熱門APP開發者！
",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            ),
            array(
                'title' => "電影分享",
                'category' => $cate->id,
                'tag1' => "OK",
                'tag2' => "太平輪",
                'tag3' => "鐵達尼拗",
                'mention_product' => $product->id,
                'blogger_id' => $blogger->id,
                'blogger_name' => $blogger->name,
                'blogger_img' => $blogger->photo,
                'img_path' => "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSJot0ey77e5ZORngo4VLXz9-OsA094AYm8n-D3Xb77FFCHX4tR",
                'youtube_url' => "https://www.youtube.com/watch?v=WlfIYn8-1pI",
                'description' => "model test test test雷神你這樣對嗎！！！？？？？(中村)",
                'isActive' => 1,
		'created_at' => '2015-09-01'
            )

        );
        DB::table('myadmin_articles')->insert($article);
    }
}


class OperatorLogTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('operator_log')->delete();
        $time = new DateTime;
        
        $admins = Administrator::all();

        for($i = 0; $i < count($admins); $i++) {
            $operators = array(
                'admin_id' => $admins[$i]->id,
                'operator' => '刪除 商品一',
                'created_at' => $time,
                'updated_at' => $time
            );
            DB::table('operator_log')->insert($operators);
        }
    }
}
class TransactionsTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = new DateTime;
        $users = User::all();

        $product = Product::firstOrfail();

        for($i = 0; $i < count($users); $i++) {
            $transaction[0] = array(
                'user_id' => $users[$i]->id,
				'order_code' => $this->generateRandomNum(8),
                'money' => 100,
                'bonus_money' => 50,
                'status' => '已出貨',
                'address' => '台南市好地方',
                'mail' => 'bee040811@gmail.com',
                'products_json' => '[{"id":"' . $product["id"] . '","num":"5"}]',
                'detail' => "購買 " . $prodcut["title"] . "5個",
                'date' => $time,
                'created_at' => $time,
                'updated_at' => $time
            );

            $transaction[1] = array(
                'user_id' => $users[$i]->id,
				'order_code' => $this->generateRandomNum(8),
                'money' => 200,
                'bonus_money' => 50,
                'status' => '尚未付款',
                'address' => '台南市'.$this->generateRandomNum(2).'號',
                'mail' => 'bee'.$this->generateRandomNum(6).'@gmail.com',
                'products_json' => '[{"id":"' . $product["id"] . '","num":"5"}]',
                'detail' => "購買 " . $prodcut["title"] . "5個",
                'date' => $time,
                'created_at' => $time,
                'updated_at' => $time
            );
            DB::table('transactions')->insert($transaction);
        }
    }
    public function generateRandomNum($length = 10) {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

}

class BonusesTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     * w
     */
    public function run()
    {
        $time = new DateTime;


        $transactions = Transaction::all();

        for($i = 0; $i < count($transactions); $i++) {
            $bonus[0] = array(
                'transaction_id' => $transactions[$i]->id,
                'user_id' => $transactions[$i]->user_id,
                'bonus' => 50,
                'description' => '成功下定',
                'type' => '紅利使用',
                'date' => $time,
                'created_at' => $time,
                'updated_at' => $time
            );
            $bonus[1] = array(
                'transaction_id' => $transactions[$i]->id,
                'user_id' => $transactions[$i]->user_id,
                'bonus' => 30,
                'description' => '成功下定2',
                'type' => '紅利使用',
                'date' => $time,
                'created_at' => $time,
                'updated_at' => $time
            );
            $bonus[2] = array(
                'transaction_id' => $transactions[$i]->id,
                'user_id' => $transactions[$i]->user_id,
                'bonus' => 100,
                'description' => '成功兌現',
                'type' => '兌現',
                'date' => $time,
                'created_at' => $time,
                'updated_at' => $time
            );
            $bonus[3] = array(
                'transaction_id' => $transactions[$i]->id,
                'user_id' => $transactions[$i]->user_id,
                'bonus' => 500,
                'description' => '成功兌現',
                'type' => '兌現',
                'date' => $time,
                'created_at' => $time,
                'updated_at' => $time
            );
            DB::table('bonuses')->insert($bonus);
        }

        DB::table('bonuses_categories')->insert(array(
            array(
                'category'=>'A方案',
                'code'=>'A9',
                'value'=>'0.2',
                'retail_value'=>'0.4',
                'introduction_value'=>'0.3',
                'bonus_value'=>'0.4',
                'created_at' => $time,
                'updated_at' => $time
            ),
            array(
                'category'=>'B方案',
                'code'=>'B9',
                'value'=>'0.3',
                'retail_value'=>'0.4',
                'introduction_value'=>'0.3',
                'bonus_value'=>'0.4',
                'created_at' => $time,
                'updated_at' => $time
            ),
            array(
                'category'=>'C方案',
                'code'=>'C9',
                'value'=>'0.4',
                'retail_value'=>'0.4',
                'introduction_value'=>'0.3',
                'bonus_value'=>'0.4',
                'created_at' => $time,
                'updated_at' => $time
            ),
        ));
    }
}

class AdministratorTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $salt = Config::get('Myadmin::admin.salt');
        $time = new DateTime;

        DB::table('administrators')->delete();

        DB::table('administrators')->insert(array(
            array(
                'account'=>'customer',
                'password'=> crypt('architech3388', $salt),
                'username'=>'jack1112',
                'email'=>'jackwang0919@gmail.com',
                'level'=>'客服人員',
                'created_at'=> $time,
                'updated_at'=> $time
            ),
            array(
                'account'=>'employee',
                'password'=> crypt('architech3388', $salt),
                'username'=>'jack0415',
                'email'=>'jackwang0919@gmail.com',
                'level'=>'退換貨人員',
                'created_at'=> $time,
                'updated_at'=> $time
            ),
            array(
                'account'=>'admin',
                'password'=> crypt('architech3388', $salt),
                'username'=>'bee040811',
                'email'=>'040811@gmail.com',
                'level'=>'最高管理員',
                'created_at'=> $time,
                'updated_at'=> $time
            ),
            array(
                'account'=>'user',
                'password'=> crypt('architech3388', $salt),
                'username'=>'bee040811',
                'email'=>'bee040811@gmail.com',
                'level'=>'客服人員',
                'created_at'=> $time,
                'updated_at'=> $time
            )
        ));
    }
}

class ProductCategoryTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        DB::table('products_categories')->delete();

        DB::table('products_categories')->insert(array(
            array(
                'name'=>'文具', 'show'=>'1'),
            array(
                'name'=>'3C', 'show'=>'1'),
			array(
				'name'=>'配飾', 'show'=>'0'),
			array(
				'name'=>'傢飾', 'show'=>'0'),
			array(
				'name'=>'日常', 'show'=>'1'),
			array(
				'name'=>'美妝', 'show'=>'1'),
			array(
				'name'=>'燈飾', 'show'=>'1'),
			array(
				'name'=>'餐廚', 'show'=>'1'),
			array(
				'name'=>'戶外', 'show'=>'1')
            ));
    }
}

class BrandTableSeeder extends Seeder { 

	public function run()
	{
		// data seeds for brands
		DB::table('brands')->delete();
        for($i = 0; $i < 3; $i++) {
            $operators[$i] = array(
                'name' => $this->generateRandomString(8),
                'description' =>"OUR MISSION BRING INSPIRATION AND INNOVATION TO EVERY ATHLETE* IN THE WORLD *IF YOU HAVE A BODY, YOU ARE AN ATHLETE.",
                'Facebook_url' => "https://www.facebook.com/",
                'Instagram_url' => "www.google.com",
                'Youtube_url' => "www.youtube.com",
                'photo' => "http://blogs-images.forbes.com/maggiemcgrath/files/2014/09/nike-just-do-it.jpg",
		'image' => "http://logok.org/wp-content/uploads/2014/03/Air-Jordan-Nike-Jumpman-logo.png",
		'buy_now' => "",
		'location' => "台中市",
		'website' => "",
                'created_at' => $time,
                'updated_at' => $time
            );
		}
		DB::table('brands')->insert($operators);
	}

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

class ProductTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        DB::table('products')->delete();

        $categories = ProductCategories::all();
        $bonus_category = BonusesCategories::all();
		$brands = Brands::all();
        $date = new DateTime;

        for($i = 0; $i < count($categories); $i++) {
			$product = array(
					'category_id'=> $categories[$i]->id,
					'title'=>'Net-' . $this->generateRandomString(5),
					'subheading'=> $brands[0]->id,
					'publish'=>'1',
					'price'=>'30',
					'selling_price'=>'50',
					'description'=>'描述',
					'img_path'=>'',
					'format'=>'yellow-S,black-XL,white-M',
					'is_available'=>'上架',
					'official_url'=>'https://www.youtube.com/watch?v=ojUUBoddvOo&index=5&list=FLU6u0txj1Z_9hiKxqowPpKA',
			);

			if($i%4 == 0){
				$products = array(
					'category_id'=> $categories[$i]->id,
					'title'=>'Net-' . $this->generateRandomString(5),
					'subheading'=>$brands[1]->id,
					'publish'=>'0',
					'price'=>'30',
					'selling_price'=>'50',
					'description'=>'描述',
					'img_path'=>'',
					'format'=>'15Wh,22Wh,44Wh',
					'is_available'=>'上架',
					'official_url'=>'https://www.youtube.com/watch?v=ojUUBoddvOo&index=5&list=FLU6u0txj1Z_9hiKxqowPpKA',
				);
	            DB::table('products')->insert(array(
    	            $products
        	    ));
			}
            DB::table('products')->insert(array(
                $product
            ));
        }
        
        $products = Product::all();

        DB::table('products_detail')->insert(array(
            array(
                'product_id'=>$products[0]->id,
                'img_title'=> 'test123',
                'img_description'=> 'good'
            )
        ));

    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}


class ShopsTableSeeder extends Seeder {

	public function run()
	{
		DB::table('shops')->delete();
		DB::table('shops')->insert(array(
			array(	'name'=>'屈臣氏', 
					'region'=>'長春店',
					'address'=>'台南市大學路1號', 
					'position_x'=>'123.23',
					'position_y'=>'456.78'
			),
			array(	'name'=>'屈臣氏', 
					'region'=>'台南店',
					'address'=>'台北市敦化北路', 
					'position_x'=>'13.23',
					'position_y'=>'56.78'
			),
			array(	'name'=>'康是美', 
					'region'=>'長春店',
					'address'='台北市中正區', 
					'position_x'=>'23.23',
					'position_y'=>'45.78'
			),
			array(	'name'=>'康是美', 
					'region'=>'台北市',
					'address'=>'台北市仁愛路', 
					'position_x'=>'23.23',
					'position_y'=>'45.78'
			),
			array(	'name'=>'康是美', 
					'region'=>'台中市',
					'address'=>'台中市中正路', 
					'position_x'=>'23.23',
					'position_y'=>'45.78'
			),
			array(	'name'=>'康是美', 
					'region'=>'台南市中西區',
					'address'=>'大學路', 
					'position_x'=>'23.23',
					'position_y'=>'45.78'
			)
		));

	}

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}


class RecordsTableSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('records')->delete();

        $users = User::all();
        for($i = 0; $i < count($users); $i++) {
            $bonus = Bonustable::where("user_id", $users[$i]->id)
                ->where("type", "紅利使用")
                ->sum('bonus');
            $money = Bonustable::where("user_id", $users[$i]->id)
                ->where("type", "兌現")
                ->sum('bonus');

            $record = array(
                'user_id'=> $users[$i]->id,
                'month_1'=>'100',
                'month_2'=>'200',
                'month_3'=>'200',
                'bonus_money'=> '30',
                'bonus_used'=> $bonus,
                'money_used'=> $money);
            DB::table('records')->insert(array(
                $record
            ));
        }
    }
}

class HomeSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('myadmin_home')->delete();
        DB::table('myadmin_home_slide')->delete();

        $home = Home::all();
		$homeslide = HomeSlide::all();

            $home = array(
                'image1'=> null,
                'link1'=>'www.google.com',
                'image2'=>null,
                'link2'=>null,
                );
            DB::table('myadmin_home')->insert(array(
                $home
            ));

			$homeslide = array(
				'image'=>'test',
				'link'=>'www.google.com'
			);

			DB::table('myadmin_home_slide')->insert(array(
				$homeslide
			));
    }
}
