<?php

class OperatorLog extends Eloquent { 

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'operator_log';

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    public static function saveItem($id, $op) 
    {
        try {
            $admin = Administrator::findOrFail($id);
            if($admin) {
                $operator = new OperatorLog;
                $operator->admin_id = $id;
                $operator->operator = $op;

                $operator->save();
            }
        } catch(\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            Session::flush();
        }
    }

    public static function getLogList() 
    {
        $operators = OperatorLog::orderBy("updated_at", 'desc')->paginate(15);
        for($i = 0; $i < count($operators); $i++) {
            $test = OperatorLog::find($operators[$i]['id'])->belongsTo('Administrator', 'admin_id', 'id')->first();
            $operators[$i]['username'] = $test['username'];
        }

        return $operators;
    }

    public static function getNewestLog($previousTime)
    {
        $operators = OperatorLog::where('updated_at', '>', $previousTime)->get();

        for($i = 0; $i < count($operators); $i++) {
            $test = OperatorLog::find($operators[$i]['id'])->belongsTo('Administrator', 'admin_id', 'id')->first();
            $operators[$i]['username'] = $test['username'];
        }

        return $operators;
    }
}
