<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/

//Route::get('admin/user/fblogin','UserController@getFblogin');
//Route::get('admin/article/like','ArticleController@getLike');
App::setLocale('tw');
$backend_prefix = Config::get('Myadmin::admin.backend_prefix');
Route::group(array(
    'prefix' => $backend_prefix,
    'before' => 'admin_auth',
    ),
    function(){
        Route::any('/', function(){
            return Redirect::to(Config::get('Myadmin::admin.backend_prefix').'/user/manage');
	});
		Route::get('article/comment',"ArticleController@getComment");
		Route::post('article/newcomment',"ArticleController@postNewcomment");
		Route::resource('article', "ArticleController");
		Route::controller('article', "ArticleController");

		Route::resource('articleclass', "ArticleClassController");
		Route::controller('articleclass', "ArticleClassController");

		Route::controller('user', "UserController");
		Route::resource('user', "UserController");

		Route::resource('userclass', "UserClassController");
		Route::controller('userclass', "UserClassController");

//		Route::get('blogger/category',"MyadminUserController@getCategory");
		Route::resource('blogger', "MyadminUserController");
		Route::controller('bolgger', "MyadminUserController");

        Route::post('product/brand', 'ProductController@brandstore');
		Route::post('product/brandedit/{id}', 'ProductController@brandupdate');
		Route::resource('product', "ProductController");
        Route::controller('product', "ProductController");

		Route::resource('productclass', "ProductClassController");
		Route::controller('productclass', "ProductClassController");

		Route::resource('activity', "ActivityController");
		Route::controller('activity', "ActivityController");

		Route::resource('activityclass', "ActivityClassController");

        Route::resource('slider', "SliderController");
        
        Route::resource('consumer', "MyadminConsumerController", array('only' => array('index', 'show')));
        Route::resource('aio', "MyadminAioController");
        
        Route::get('home/reports-data', 'Bee040811\HomeManagement\Controllers\HomeManagementController@getReportsData');   
        Route::get('home/follow/{id}', "HomeController@getFollow");
        Route::resource('home', 'Bee040811\HomeManagement\Controllers\HomeManagementController');   
        Route::controller('home', 'Bee040811\HomeManagement\Controllers\HomeManagementController');   
		
//action
//Route::get('front/islike', 'FrontController@getIslike');
//Route::get('front/oneAction', 'FrontController@getOneAction');
    }
);

//action
Route::get('admin/front/like','frontController@getLike');
Route::get('admin/front/fblogin','FrontController@getFblogin');
Route::get('front/login','FrontController@postLogin');
Route::get('admin/front/logout','FrontController@getLogout');
Route::get('admin/front/islike', 'FrontController@getIslike');
Route::get('admin/front/oneAction', 'FrontController@getOneAction');

//pass data
Route::get('admin/front/about', 'FrontController@getAbout');
Route::get('admin/front/lookers', 'FrontController@getLookers');
Route::get('admin/front/lookerinfo', 'FrontController@getLookerinfo');
Route::get('admin/front/video', 'FrontController@getVideo');
Route::get('admin/front/profile', 'FrontController@getProfile');
Route::get('admin/front/profile_follow', 'FrontController@getProfileFollow');
Route::get('admin/front/searchresult', 'FrontController@getSearchResult');
Route::get('admin/front/actions', 'FrontController@getActions');
Route::post('admin/front/checkstore', 'FrontController@checkstore');
Route::resource('admin/front', "FrontController");
Route::controller('admin/front', "FrontController");

//Route::controller('admin/home', "HomeController");

Route::any('getislike',function(){
	return 0;
});


//get the blogger name by auto
Route::any('getblogger/{term}', function($term){
    $data = DB::table('bloggers')->distinct()->select('name')->where('name', 'LIKE', '%'.$term.'%')->groupBy('name')->get();
    $return_array = [];
    foreach($data as $v)
	    $return_array[] =  array('value'=> $v->name);

  return Response::json($return_array);
});
Route::any('getproducts/{term}', function($term){
    $data = DB::table('products')->distinct()->select('title')->where('title', 'LIKE', $term.'%')->groupBy('title')->get();
    $return_array = [];
    foreach($data as $v)
	    $return_array[] =  array('value'=> $v->title);

  return Response::json($return_array);
});


Route::get('/', function()
{
	return View::make('hello');
});

// to show operator log
Route::get('/admin/operators-log', 'Lucaswei\Myadmin\Controllers\MyadminController@getOperators');
//
// to load all admin method, but maybe conflict with other controller
//Route::controller('admin', 'Lucaswei\Myadmin\Controllers\MyadminController');
Route::controller('test2', 'Bee040811\Bonus\Controllers\UserRecordsController');   

Route::get('/admin/testbee', 'ProductController@testbee');
