@extends('layout.basic_front')

@section("content")
<!DOCTYPE HTML>
<html lang="zh-TW">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Looknow!</title>
        <!-- jQuery -->
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>

        <!-- Latest compiled and minified CSS -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">

        <!-- Optional theme -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap-theme.min.css">

        <!-- Latest compiled and minified JavaScript -->
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>

        <!-- customized css -->
        <link rel="stylesheet" href="../../../css/looknow.css">

    </head>
    <body>
        <div class="container inline-content">
            <h1>Receipt</h1>
			<br>
            <form class="form-inline" accept-charset="utf-8">
				@for ($i = 0 ; $i < count($products) ; $i++ )
                <div class="row">
                    <div class="col-md-1">
                        <a href="#">
					{{ HTML::image($productimgs[$i]->image,"",['class'=>"img-circle",'style'=>'width:100px']) }}
{{--                            <img class="img-responsive" src="./images/product-240.jpg">	--}}
                        </a>
                    </div>
                    <div class="col-md-3">
                        <h2>{{$products[$i]->title}}</h2>
                    </div>
                    <div class="col-md-3">
                        <p>{{$productformat[$i]}}</p>
                    </div>
                    <div class="col-md-3">
                        <p>X{{$productnumber[$i]}}</p>
                    </div>
                    <div class="col-md-2">
                        <p class="price">${{$productprice[$i]}}</p>
                    </div>
                </div>
                <hr/>
				@endfor
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <p class="total">NT 1024</p>
                    </div>
                </div>
                <div class="row">
                    <p>對焦輔助燈為綠色。但就小編使用過的數位單眼相機來說，K-S2的對焦輔助燈觸動的時機比我想像中還要來得特別一些。幾乎是要暗到全黑的時候對焦輔助燈才會亮起。小編使用的Nikon通常會在稍暗的地方就會亮了。<br/>
                    
                    不過K-S2有不亮對焦輔助燈的本錢，因為它的對焦檢測範圍最低可到-3EV，而一般來說-2EV是人眼可分辨細節的極限。以Nikon的器材來說，只有最新的全片幅相機D750可以達到-3EV，Canon則是目前新款的全片幅相機都可以達到。而-4EV的寶座依然要歸給Panasonic GH4，或即將發表的G7等等。<br/><br/>
                    
                    不過一般的機種，即使是數位單眼也差不多都在-1或-2EV之間，能夠到-3EV已經是非常了不起了。
                    </p>
                    <a href="{{URL::to('admin/front')}}" class="btn btn-default btn-lg pull-right col-md-4">ok</a>
                </div>
            </form>
        </div>
    </body>
</html>

<script type="text/javascript" charset="utf-8">
	$(document).ready(function(){
		var productprice = {{json_encode($productprice)}};
		var price = 0;
		
		for (var i = 0 ; i<productprice.length ; i++){
			price += parseInt(productprice[i]);
		}
		$(".total").text("NT "+price);

	});
</script>

@stop
