@extends('layout.basic_front')

@section("content")
    <div class="container-fluid" id="map" style="height:400px">	
	    <iframe  width="100%" height="400px" frameborder="0" style="border:0" allowfullscreen></iframe>
	</div>

<script src="https://maps.googleapis.com/maps/api/js"></script>
<script>
	var markers = {{ json_encode($sort) }};
	console.log(markers);
    function initialize() {
        var myLatLng = {lat: parseFloat('{{$latitude}}'), lng: parseFloat('{{$longitude}}')};
//        console.log(myLatLng);
        var mapCanvas = document.getElementById('map');
        var mapOptions = {
          center: myLatLng,
          zoom: 14,
          mapTypeId: google.maps.MapTypeId.ROADMAP,
		  styles:[{"featureType":"water","elementType":"geometry","stylers":[{"color":"#e9e9e9"},{"lightness":17}]},{"featureType":"landscape","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":20}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffffff"},{"lightness":17}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#ffffff"},{"lightness":29},{"weight":0.2}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":18}]},{"featureType":"road.local","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":16}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":21}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#dedede"},{"lightness":21}]},{"elementType":"labels.text.stroke","stylers":[{"visibility":"on"},{"color":"#ffffff"},{"lightness":16}]},{"elementType":"labels.text.fill","stylers":[{"saturation":36},{"color":"#333333"},{"lightness":40}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#f2f2f2"},{"lightness":19}]},{"featureType":"administrative","elementType":"geometry.fill","stylers":[{"color":"#fefefe"},{"lightness":20}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#fefefe"},{"lightness":17},{"weight":1.2}]}]
        }
        var map = new google.maps.Map(mapCanvas, mapOptions);

		for (i = 0 ; i < markers.length ; i++){

			var marker = new google.maps.Marker({
				position: {lat:parseFloat(markers[i].position_x), lng: parseFloat(markers[i].position_y)},
				map: map,
				title: markers[i].name,
				icon: "{{URL::to('images/icons/icon_for_map.png')}}",
				info: markers[i].address
			});

			var infowindow = new google.maps.InfoWindow({
				content: markers[i].address
			});

			google.maps.event.addListener(marker, 'click', function () {
    	        infowindow.setContent(this.info);
        	    infowindow.open(map, this);
	        });

//			marker.addListener('click', function() {
//				infowindow.setContent(this.info);
//				infowindow.open(marker.get('map'), marker);
//			});
		}
    }
    google.maps.event.addDomListener(window, 'load', initialize);
</script>

@stop
