@extends('Myadmin::layout.basic')

@section('header')
    <style>
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }
        #content .table {
            font-size:12px;
        }

        .head-table {
            width:100%;
        }
    </style>
@stop

@section('content')
   <div class="row-fluid">
    	<div class="span9">
    	</div>
        <div>
            <h4 class="nametag">管理員系統</h4>
		<br><br><br>

	<h5>{{Session::get('message')}}</h5>

        @if($errors->any())
        <div class="alert alert-danger">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          <strong>Send </strong> {{$errors->first()}}
        </div>
        @endif

		<hr>
		<div class="row">
	            <div class = "col-xs-8 col-sm-8 col-md-8">    
			<a class="btn btn-primary" data-toggle="modal" data-target=".bs-example-modal-sm">
				<span class="glyphicon glyphicon-file"></span>
				新增管理者帳戶
			</a>
		   </div>
		   <div class = "col-md-4 col-ms-4 col-xs-4 pull right" style="margin-top:10px">
			<div class="input-group">
				<input type="text" id="user_search" value="" class="form-control" placeholder="user's account"/>
				<!--input type="text" id="user_condition_search" value="" class="form-control" placeholder="搜尋條件"/-->
                                <span class="input-group-btn">
                                    <button class="btn btn-default" type="button" name="search" onclick="searchByIE()">Seach</button>
                                </span>
			</div>
		   </div>
                </div>
		<br><hr>
                <table class="table table-bordered" id="user-table">
              <thead>
                    <!--tr><th>Account</th><th>身分字號</th><th>出生日期</th><th>手機號碼</th><th>信箱</th><th>住址</th><th>紅利</th><th>操作</th><th>狀態</th></tr-->
                    <tr><th>建立時間</th><th>會員帳號</th><th>帳戶狀態</th><th>帳戶權限</th><th>會員名稱</th><th>功能按鈕</th></tr>
              </thead>
              <tbody>
              @foreach ($managers as $manager)
                <tr>

		<td>{{$manager->created_at}}</td>
                <td><a href="#">{{$manager->account}}</td>
                <td><?php echo "正常";//echo($manager->is_available == 0)?"停權":"權限正常"; ?></td>
		<td>{{$manager->level}}</td>
		<td id="td_user_account">{{$manager->username}}</td>

                <td>

                    <a href="{{URL::to('admin/user/send-passwd/'.$manager->id)}}" class='btn btn-warning glyphicon glyphicon glyphicon-envelope' 
				onclick="if(!confirm('是否寄送密碼')){return false;}"></a>
                </td>
                </tr>
                @endforeach
              </tbody>
            </table>
        <script language="JavaScript">

            $(document).ready(function(){
                // Write on keyup event of keyword input element
                    $("#user_search").keyup(function(){
                        // When value of the input is not blank
                        search($(this).val());
                    });
		setInterval(function(){$("[name=register-time]").val(getCurrentDate());},1000);
            });
            // jQuery expression for case-insensitive filter
            $.extend($.expr[":"], 
            {
             "contains-ci": function(elem, i, match, array) 
                    {
                          return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
                    }
            });
    
            function searchByIE() {
                search(document.getElementById("user_search").value);
            }

            function search(key) {
                if( key != "") {
                        // Show only matching TR, hide rest of them
                        $("#user-table tbody>tr").hide();
                        $("#user-table #td_user_account:contains-ci('" + key + "')").parent("tr").show();
                } else {
                        // When there is no input or clean again, show everything back
                        $("#user-table tbody>tr").show();
                }
            }
        </script>
    </div> <!-- div -->
</div> <!-- .row-fluid -->
@stop

@section('dialog')
    <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          <h4 class="modal-title" id="mySmallModalLabel">新增管理者帳戶</h4>
    </div>
    
	<div class="modal-body">
    	{{ Form::open(array('url' => '/admin/user/add-manager', 'id' => 'add-user-form'))}}
                <div class="form-group">
                        <label class="control-label col-sm-4">帳戶權限</label>
                        <div class="col-sm-8">
				{{ Form::select('authority', array('最高管理員' => '管理', '客服人員' => '客服','會計人員' => '會計','退換貨人員' => '倉儲'), '會計人員',['class' => 'form-control']) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">帳戶狀態</label>
                        <div class="col-sm-8">
				{{ Form::select('status', array('正常' => '正常', '停權' => '停權'),'正常',['class' => 'form-control']) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">登入帳號</label>
                        <div class="col-sm-8">
				{{ Form::text('account','', array('class' => 'form-control')) }}
			</div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">登入密碼</label>
                        <div class="col-sm-8">
				{{ Form::password('password', array('class' => 'form-control')) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">email</label>
                        <div class="col-sm-8">
				{{ Form::text('email','', array('class' => 'form-control')) }}
                        </div>
                </div> <br><br>
		<div class="form-group">
			<label class="control-label col-sm-4">建立時間</label>
			<div class="col-sm-8">
				{{ Form::text('register-time','', array('class' => 'form-control')) }}
			</div>
		</div> <br><br>
                <div class="form-group">
				{{ Form::submit('送出', array('class' => 'btn btn-primary')) }}
                </div>
    	{{ Form::close() }}
	</div>
@stop

