@extends('Myadmin::layout.basic')

@section('header')
<script>
$(document).ready(function(){
    $('.percent').val(function(index, old) { return old.replace(/[^0-9|\.]/g, '') + '%'; });
    $('.percent').change(function(e) {
        $(this).val(function(index, old) { return old.replace(/[^0-9|\.]/g, '') + '%'; });
    });
    $('.bonus-detail input').change(function(e) {
        var strArr = $("#change-index").val().split(",");
        var arr = strArr.map(function(x) {
            if(x != "") {
                return parseInt(x, 10);
            }
        });
        arr = arr.filter(Number);

        var id = $(this).parents("tr").data("id");
        var idx = arr.indexOf(id);

        if(idx == -1) {
            arr.push(id);
            var str = arr.join();
            $("#change-index").val(str);
        }
    });

    $(".save").click(function(){
        var obj = [];

        var strArr = $("#change-index").val().split(",");
        console.log(strArr);
        strArr.forEach(function(id){
            var tr = $(".bonus-detail tr[data-id=" + id + "]");
            console.log(tr);
            var entry = {};
            entry['id'] = id;
            entry['category'] = tr.find(".name");
            entry['retail-value'] = tr.find(".retail-value");
            entry['introduction-value'] = tr.find(".introduction-value");
            entry['bonus-value'] = tr.find(".bonus-value");
            entry['value'] = tr.find(".value");
            obj.push(entry);
        });

        $.get("{{URL::to('admin/mupdate')}}", {"obj": obj}, function(data){
            console.log(data);
        });
    });
});
    </script>
    <style>
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }

        #bonus-form {
            text-align:center;
        }
        
        #bonus-form td {
            padding:10px;
        }
    </style>
@stop

@section('content')
<div class="row-fluid">
    <div class="span9">
    </div>
    <div>
        <h4 class="nametag">使用者管理系統</h4>
        <hr>
        <div class="button-menu row">
            <div class="col-md-8 col-xs-8">
                @if($errors->has())
                    <a class="btn btn-warning" data-toggle="modal" data-target=".bs-example-modal-sm">新增紅利類別</a>
                    <span class="label label-danger">新增失敗</span>
                @else
                    <a class="btn btn-primary" data-toggle="modal" data-target=".bs-example-modal-sm">新增紅利類別</a>
                @endif
                <a class="btn btn-primary save">儲存修改</a>
            </div>
            <div class="col-md-4 col-xs-4">
                <div class="input-group">
                    <input type="text" id="user_search" value="" class="form-control" placeholder="紅利編碼"/>
                    <span class="input-group-btn">
                        <button class="btn btn-default" type="button" name="search" onclick="searchByIE()">Seach</button>
                    </span>
                </div>
            </div>
        </div>
        <hr>
        <input type="hidden" class="hidden" id="change-index"/>
        <table class="table table-bordered bonus-detail">
            <thead>
                <tr>
                    <th>紅利編碼</th>
                    <th>紅利名稱</th>
                    <th>門市點數</th>
                    <th>介紹點數</th>
                    <th>分紅點數</th>
                    <th>變更日期</th>
                </tr>
            </thead>
            @foreach($bonus_detail as $bonusData)
                <tr data-id="{{ $bonusData->id  }}">
                    <td>{{ $bonusData->code }}</td>
                    <td><input class="name" value="{{ $bonusData->category }}"></td>
                    <td><input class="percent retail-value" value="{{ $bonusData->retail_value}}"></td>
                    <td><input class="percent introduction-value" value="{{ $bonusData->introduction_value}}"></td>
                    <td><input class="percent bonus-value" value="{{ $bonusData->bonus_value}}"></td>
                    <td>{{ $bonusData->updated_at}}</td>
                </tr>
            @endforeach
        </table>
        @if(Session::has('message'))
            <div class="alert alert-warning" role="alert">{{ Session::get('message') }}</div>
        @endif
    </div>
</div>

@stop

@section('dialog')
    <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          <h4 class="modal-title" id="mySmallModalLabel">新增紅利類別</h4>
    </div>
    {{ Form::open(array('url' => 'admin/bonus', 'id' => 'bonus-form'))}}
    <table>
        <tr>
            <td>紅利編碼</td>
            <td>{{ Form::text('code','', array('class' => 'form-control')) }}</td>
        </tr>
        <tr>
            <td>紅利名稱</td>
            <td>{{ Form::text('name','', array('class' => 'form-control')) }}</td>
        </tr>
        <tr>
            <td>門市點數</td>
            <td>{{ Form::text('retail-value','', array('class' => 'form-control')) }}</td>
        </tr>
        <tr>
            <td>介紹點數</td>
            <td>{{ Form::text('introduction-value','', array('class' => 'form-control')) }}</td>
        </tr>
        <tr>
            <td>分紅點數</td>
            <td>{{ Form::text('bonus-value','', array('class' => 'form-control')) }}</td>
        </tr>
        <tr>
            <td colspan=2>
                @if($errors->has())
                    <div class="alert alert-warning" role="alert">{{ $errors->first() }}</div>
                @endif
            </td>
        </tr>
        <tr>
            <td></td>
            <td>{{ Form::submit('送出', array('class' => 'btn btn-primary')) }}</td>
        </tr>
    </table>
    {{ Form::close() }}

@stop
