@extends('Myadmin::layout.basic')

@section('header')
    <style>
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }
        #content .table {
            font-size:12px;
        }

        .head-table {
            width:100%;
        }
    </style>
@stop

@section('content')
   <div class="row-fluid">
    	<div class="span9">
    	</div>
        <div>
            <h4 class="nametag">使用者管理系統</h4>
		<br><br><br>

	<h5>{{Session::get('message')}}</h5>
        @if(Session::get('info'))
        <div class="alert alert-info">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          <strong>注意!</strong> {{Session::get('info')}}
        </div>
        @endif

	@if($errors->first() == "1")
        <div class="alert alert-success">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          <strong>寄送成功!</strong>
        </div>
<!--	@elseif($errors->first() == "success!")
        <div class="alert alert-success">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          <strong>已封鎖留言者!</strong>
        </div>
-->
        @elseif($errors->any())
        <div class="alert alert-danger">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          <strong>錯誤!</strong> {{$errors->first()}}
        </div>
	@endif

		<hr>
		<div class="row">
	            <div class = "col-xs-8 col-sm-8 col-md-8">    
			<a href={{ URL::to('admin/user/create-user')}} class="btn btn-primary">
        	            <span class="glyphicon glyphicon-file"></span>
                	    新增使用者
	                </a>
		<!--a><img  id = "fb-login" src="http://onestep.in/shoppingbaba/assets/images/fb.png" style = "width:120px; height:40px;"></img></a-->
		<!--div class="fb-login-button" id="fb-auth" data-max-rows="1" data-size="medium" data-show-faces="false" data-auto-logout-link="true"></div-->
		<!--a class="btn btn-info" href={{ URL::to('admin/user/login')}}>使用者登入(測試)</a-->
		   </div>
		   <div class = "col-md-4 col-ms-4 col-xs-4 pull right" style="margin-top:10px">
			<div class="input-group">
				<input type="text" id="user_search" value="" class="form-control" placeholder="user's name"/>
                                <span class="input-group-btn">
                                    <button class="btn btn-default" type="button" name="search" onclick="searchByIE()">Seach</button>
                                </span>
			</div>
		   </div>
                </div>
		<br><hr>
                <table class="table table-bordered" id="user-table">
              <thead>
                    <tr><th>註冊時間</th><th>登入方式</th><th>會員編號</th><th>帳戶狀態</th><th>帳戶權限</th><th>會員名稱</th><th>聯絡電話</th><th>功能按鈕</th><th>功能按鈕</th><th>功能按鈕</th></tr>
              </thead>
              <tbody>
              @foreach ($users as $user)
                <tr>

		<td>{{$user->register_time}}</td>
		<td>{{$user->login_type}}</td>
                <td><a href="{{URL::to('admin/user/detail/'.$user->id)}}">{{$user->id}}</td>
                <td><?php echo($user->is_available == 0)?"停權":"權限正常"; ?></td>
		<td>{{$user->authority}}</td>
		<td id="td_user_account">{{$user->name}}</td>
                <td>{{$user->phone}}</td>

                <td>
                    <form action="{{ URL::to('admin/user/delete-user') }}" method="POST" style="display:inline">
                                        <input type="hidden" name="id" value="{{ $user->id }}" />
                                        <button name="del" type="submit" class='<?php if($user->is_available ==0)
											echo "btn btn-info glyphicon glyphicon-ok row-ok";
										      else
											echo "btn btn-danger glyphicon glyphicon-remove row-remove";?>'
 								onclick="if(!confirm('確定要改變此使用者帳戶權限?'))
								{return false;};">權限
					</button>
                                </form>
		</td>
		<td>
		    @if($user->comment_is_available == '1')
                    	<a href="{{URL::to('admin/user/delete-commentator/'.$user->id)}}" class='btn btn-success glyphicon glyphicon glyphicon-remove' 
				onclick="if(!confirm('是否封鎖此留言者')){return false;}">封鎖留言者</a>
		    @else
                    	<a href="{{URL::to('admin/user/delete-commentator/'.$user->id)}}" class='btn btn-default glyphicon glyphicon glyphicon-ok' 
				onclick="if(!confirm('是否解除封鎖此留言者')){return false;}">解除封鎖</a>
		    @endif
		</td>
		<td>
		    <a href="{{URL::to('admin/user/delete-all-comments/'.$user->id)}}" class='btn btn-warning glyphicon glyphicon glyphicon-envelope'
                                onclick="if(!confirm('是否刪除所有留言？')){return false;}">刪除所有留言</a>    
		    <!--
		    @if($user->login_type == 'Looknow')
                    	<a href="{{URL::to('admin/user/send-passwd/'.$user->id)}}" class='btn btn-warning glyphicon glyphicon glyphicon-envelope' 
				onclick="if(!confirm('是否寄送密碼')){return false;}"></a>
		    @else
                    	<a href=# class='btn btn-default glyphicon glyphicon glyphicon-envelope' 
				onclick="{alert('此為facebook 登入用戶 無法傳送更改密碼！'); return false;}"></a>
		    @endif
		    -->
                </td>
                </tr>
                @endforeach
              </tbody>
            </table>
        <script language="JavaScript">
////FB///////////
	    window.fbAsyncInit = function() {
                    FB.init({
                    appId      : '558716530932928',
                    xfbml      : true,
                    version    : 'v2.4'
                    });

//////////
	    function updateButton(response){
		  var button = document.getElementById('fb-auth'), r = [], check = 1;

		  if (response.status === 'connected') {
   		      FB.api('/me?fields=name,id,email,gender', function(response) {
	              for (var key in response) {
              		  r.push(response[key]);
                  }
                  console.log(r);
		       @if(Session::has('info'))
        		        check = 0;
       	      	       @endif

        		if(check)
        		{
	                	//redirect
	               		var url = "{{URL::to('admin/user/fblogin/')}}" + '/'+ r;
        		        window.location.href= url;
		        }
      		     });
  		  }
		else
		 {
			FB.login(function(response) {
			        Log.info('FB.login callback', response);
			});
		 }
		}
		document.getElementById("fb-login").onclick = function(){
			FB.getLoginStatus(updateButton);
			FB.Event.subscribe('auth.statusChange', updateButton);
		}
	    };
	
	          (function(d, s, id){
        	     var js, fjs = d.getElementsByTagName(s)[0];
	             if (d.getElementById(id)) {return;}
        	     js = d.createElement(s); js.id = id;
	             js.src = "//connect.facebook.net/en_US/sdk.js";
        	     fjs.parentNode.insertBefore(js, fjs);
	           }(document, 'script', 'facebook-jssdk'));

//////////////
            $(document).ready(function(){
                
		// Write on keyup event of keyword input element
                    $("#user_search").keyup(function(){
                        // When value of the input is not blank
                        search($(this).val());
                    });
		// select event
               $("select[name=id]").change(function(){
			var value =$("select[name=id]").val();
		 	var URL = 'http://106.187.42.25/new-jack/new-nineten/public/admin/user/memberlist/'+value;
			window.location = URL;
		return false;
              });
		
		setInterval(function(){$("[name=register-time]").val(getCurrentDate());},1000);
            });
            // jQuery expression for case-insensitive filter
            $.extend($.expr[":"], 
            {
             "contains-ci": function(elem, i, match, array) 
                    {
                          return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
                    }
            });
   		
            function searchByIE() {
                search(document.getElementById("user_search").value);
            }

            function search(key) {
                if( key != "") {
                        // Show only matching TR, hide rest of them
                        $("#user-table tbody>tr").hide();
                        $("#user-table #td_user_account:contains-ci('" + key + "')").parent("tr").show();
                } else {
                        // When there is no input or clean again, show everything back
                        $("#user-table tbody>tr").show();
                }
            }
        </script>
    </div> <!-- div -->
</div> <!-- .row-fluid -->
@stop

@section('dialog')
    <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          <h4 class="modal-title" id="mySmallModalLabel">新增種子帳戶</h4>
    </div>
    
	<div class="modal-body">
    	{{ Form::open(array('url' => '/admin/user/add-seed-user', 'id' => 'add-user-form'))}}
		<div class="form-group">
			<label class="control-label col-sm-4">註冊時間</label>
			<div class="col-sm-8">
				{{ Form::text('register-time','', array('class' => 'form-control')) }}
			</div>
		</div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">登入方式</label>
                        <div class="col-sm-8">
				{{ Form::select('login-type', array('NINETEN' => 'NINETEN', 'Facebook' => 'Facebook'),'NINETEN',['class' => 'form-control']) }}
		        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">帳戶權限</label>
                        <div class="col-sm-8">
				{{ Form::select('authority', array('一般' => '一般', '特殊' => '特殊'),'特殊',['class' => 'form-control']) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">帳戶狀態</label>
                        <div class="col-sm-8">
				{{ Form::select('status', array('正常' => '正常', '停權' => '停權'), '正常',['class' => 'form-control']) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">登入信箱</label>
                        <div class="col-sm-8">
				{{ Form::text('email','', array('class' => 'form-control')) }}
			</div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">種子姓名</label>
                        <div class="col-sm-8">
				{{ Form::text('name','', array('class' => 'form-control')) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
                        <label class="control-label col-sm-4">手機號碼</label>
                        <div class="col-sm-8">
				{{ Form::text('phone','', array('class' => 'form-control')) }}
                        </div>
                </div> <br><br>
                <div class="form-group">
				{{ Form::submit('送出', array('class' => 'btn btn-primary')) }}
                </div>
    	{{ Form::close() }}
	</div>
@stop

