<?php namespace Bee040811\Bonus\Controllers;

use Illuminate\Support\ServiceProvider;

class BonusController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';
    //protected $layout = 'bonus::layouts.basic';
    
    public function __construct()
    {
        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;
    }

    /* splay a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $bonusDetail = \BonusesCategories::all();
        //
        return \View::make('bonus::bonus')
            ->with('_CONST', $this->_CONST)
            ->withBonusDetail($bonusDetail);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        //
        // validate
        // read more on validation at http://laravel.com/docs/validation
        $rules = array(
            'code'       => 'required|unique:bonuses_categories',
            'name'       => 'required',
            'retail-value'       => 'required',
            'introduction-value'       => 'required',
            'bonus-value'       => 'required',
        );
        $validator = \Validator::make(\Input::all(), $rules);

        $bonusDetail = \BonusesCategories::all();
        // process the login
        if ($validator->fails()) {
            return \Redirect::to('admin/bonus')
                ->withErrors($validator)
                ->withInput(\Input::all())
                ->withBonusDetail($bonusDetail);
        } else {
            // store
            $bonus = new \BonusesCategories;
            $bonus->code = \Input::get('code');
            $bonus->category = \Input::get('name');
            $bonus->introduction_value = \Input::get('introduction-value');
            $bonus->bonus_value = \Input::get('bonus-value');
            $bonus->retail_value = \Input::get('retail-value');
            $bonus->value = \Input::get('retail-value');

            $bonus->save();

            // redirect
            \Session::flash('message', 'Successfully created!');
            return \Redirect::to('admin/bonus');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        //
    }

    public function mupdate()
    {
        //
        $obj = json_decode(\Input::get("obj"));

        foreach($obj as $entry) {
            $bonus = \BonusesCategories::find($entry->id);

            $bonus->code = $entry->code;
            $bonus->category = $entry->category;
            $bonus->introduction_value = $entry->introduction_value;
            $bonus->bonus_value = $entry->bonus_value;
            $bonus->retail_value = $entry->retail_value;
            $bonus->value = $entry->retail_value;

            $bonus->save();
        }
        $msg["success"] = 1;
        $msg["message"] =  "Save Success!";
        return $msg;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }

    public function getIndex()
    {
        return \View::make('bonus::bonus')
            ->with('_CONST', $this->_CONST);
    }

    public function getBack()
    {
        return \Redirect::back();
    }

    public function getSearch($id = NULL)
    {

        $records = array();
        $user = array();
        $bonuses = array();
        $level = \Session::get('level');

        if ($id) {
            $result = \User::find($id);
            if($result) {
                $user = $result->get();
                $records = \User::find($user[0]['id'])->hasOne('Record', 'user_id')->get();
                $bonuses = \Bonustable::where('user_id', '=', $user[0]['id'])->get();
            }
        }

        return \View::make('bonus::search')
            ->withRecords($records)
            ->withUsers($user)
            ->withBonuses($bonuses)
            ->with('_CONST', $this->_CONST);
    }
    
    public function getBonusDetail($id = NULL, $type = NULL)
    {
        if (!$id || !$type) {
			return \Redirect::back();
        } else {
            $result = \User::find($id);

            if($result) {
                $bonuses = \Bonustable::where("user_id", $id)
                    ->where("type", $type)->get();
                $user = $result->get();
    
                $level = \Session::get('level');

                return \View::make('bonus::bonusDetail')
                    ->withBonuses($bonuses)
                    ->with('_CONST', $this->_CONST)
                    ->withUser($user[0]);
            }
        }
    }

}
