<?php namespace Bee040811\Bonus\Controllers;

use Illuminate\Support\ServiceProvider;

class MigsController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';
    //protected $layout = 'bonus::layouts.basic';

    public function __construct()
    {
        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;
    }

    /* splay a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {

        $product= \Product::firstOrFail();;
        //
        return \View::make('bonus::migs')
            ->with('_CONST', $this->_CONST)
            ->withProduct($product);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }

    public function getQuery()
    {
        return \View::make('bonus::migsquery')
            ->with('_CONST', $this->_CONST);
    }
    
    public function getInit()
    {
        echo phpinfo();
        return \View::make('bonus::migsquery')
            ->with('_CONST', $this->_CONST);
    }

    public function migsdo()
    {
        
        $SECURE_SECRET = "DC3F7D13FDD8C77D104E0345F4EC6E1D";

        // add the start of the vpcURL querystring parameters
        $_POST["virtualPaymentClientURL"] = "https://migs.mastercard.com.au/vpcpay";
        $_POST["vpc_Version"] = 1;
        $_POST["vpc_Command"] = "pay";
        $_POST['vpc_ReturnURL'] = \URL::to('admin/migs/dr');
        $_POST['vpc_Merchant'] = "testskbtest02";
        $_POST['vpc_AccessCode'] = "929E06E6";

        $vpcURL = $_POST["virtualPaymentClientURL"] . "?";

        // Remove the Virtual Payment Client URL from the parameter hash as we 
        // do not want to send these fields to the Virtual Payment Client.
        unset($_POST["virtualPaymentClientURL"]); 
        unset($_POST["SubButL"]);

        // The URL link for the receipt to do another transaction.
        // Note: This is ONLY used for this example and is not required for 
        // production code. You would hard code your own URL into your application.

        // Get and URL Encode the AgainLink. Add the AgainLink to the array
        // Shows how a user field (such as application SessionIDs) could be added
        //$_POST['AgainLink']=urlencode($HTTP_REFERER);

        // Create the request to the Virtual Payment Client which is a URL encoded GET
        // request. Since we are looping through all the data we may as well sort it in
        // case we want to create a secure hash and add it to the VPC data if the
        // merchant secret has been provided.
        $md5HashData = $SECURE_SECRET;


        $rules = array(
            'email'       => 'required|email',
        );
        $validator = \Validator::make(\Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return \Redirect::back()
                ->withErrors($validator);
        } else {
            $obj = json_decode($_POST["products"], true);
            $detail = "購買 ";
            $money = 0;
            for($i = 0; $i < count($obj); $i++) {
                $product = \Product::find($obj[$i]["id"]);
                $detail .= $product->title . " " . $obj[$i]["num"] . "個<br>";
                $money += $product->selling_price * intval($obj[$i]["num"]);
            }
            
            $id = \User::firstOrFail();
            //TODO compare total money
            $transaction = new \Transaction;
            $transaction->user_id = $id->id;
            $transaction->mail = $_POST['email'];
            $transaction->money = $money;//$_POST['vpc_Amount'];
            $transaction->bonus_money = 1;
            $transaction->products_json = $_POST["products"];
            $transaction->status = "尚未付款";
            $transaction->date = $transaction->freshTimestamp();
            $transaction->detail = $detail;

            $transaction->touch();

            $transaction->save();
            $transaction->order_code= $transaction->id;
            $transaction->save();

            $_POST['vpc_MerchTxnRef'] = $transaction->id;
            $_POST['vpc_Amount'] *= 100;

            ksort ($_POST);

            // set a parameter to show the first pair in the URL
            $appendAmp = 0;

            foreach($_POST as $key => $value) {

                // create the md5 input and URL leaving out any fields that have no value
                if (strlen($value) > 0) {

                    // this ensures the first paramter of the URL is preceded by the '?' char
                    if ($appendAmp == 0) {
                        $vpcURL .= urlencode($key) . '=' . urlencode($value);
                        $appendAmp = 1;
                    } else {
                        $vpcURL .= '&' . urlencode($key) . "=" . urlencode($value);
                    }
                    $md5HashData .= $value;
                }
            }

            // Create the secure hash and append it to the Virtual Payment Client Data if
            // the merchant secret has been provided.
            if (strlen($SECURE_SECRET) > 0) {
                $vpcURL .= "&vpc_SecureHash=" . strtoupper(md5($md5HashData));
            }

            // FINISH TRANSACTION - Redirect the customers using the Digital Order
            // ===================================================================
            header("Location: ".$vpcURL);
            echo ("Location: ".$vpcURL);
            die();
        }
    }
}
