<?php namespace Bee040811\Bonus\Controllers;

use Illuminate\Support\ServiceProvider;

class UserRecordsController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';
    //protected $layout = 'bonus::layouts.basic';
    
    public function __construct()
    {
        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;
    }

    public function getIndex()
    {
        return \View::make('bonus::bonus')
            ->with('_CONST', $this->_CONST);
    }

    public function getBack()
    {
        return \Redirect::back();
    }

    public function getSearch($id = NULL)
    {

        $records = array();
        $user = array();
        $bonuses = array();
        $level = \Session::get('level');

        if ($id) {
            $result = \User::find($id);
            if($result) {
                $user = $result->get();
                $records = \User::find($user[0]['id'])->hasOne('Record', 'user_id')->get();
                $bonuses = \Bonustable::where('user_id', '=', $user[0]['id'])->get();
            }
        }

        return \View::make('bonus::search')
            ->withRecords($records)
            ->withUsers($user)
            ->withBonuses($bonuses)
            ->with('_CONST', $this->_CONST);
    }
    
    public function getBonusDetail($id = NULL, $type = NULL)
    {
        if (!$id || !$type) {
			return \Redirect::back();
        } else {
            $result = \User::find($id);

            if($result) {
                $bonuses = \Bonustable::where("user_id", $id)
                    ->where("type", $type)->get();
                $user = $result->get();
    
                $level = \Session::get('level');

                return \View::make('bonus::bonusDetail')
                    ->withBonuses($bonuses)
                    ->with('_CONST', $this->_CONST)
                    ->withUser($user[0]);
            }
        }
    }
}
