<?php namespace Bee040811\Delivery\Controllers;

use Illuminate\Support\ServiceProvider;

class DeliveryController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';
    //protected $layout = 'bonus::layouts.basic';
    
    public function __construct()
    {
        $routeName = \Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = \Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));

        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["level"] = $level;
        $this->_CONST["title"] = "網站管理系統";
        $this->_CONST["operators"] = $operators;
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST['CONTROLLER_ACTION'] = $routeAction;
    }

    /* splay a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $backends = \Backend::all();

        return \View::make('delivery::index')
            ->with('_CONST', $this->_CONST)
            ->withBackends($backends);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
        return \View::make('delivery::delivery')
            ->with('_CONST', $this->_CONST);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        //
        // validate
        // read more on validation at http://laravel.com/docs/validation
        $rules = array(
            'title'       => 'required|unique:backends,title',
            'url'       => 'required|unique:backends,url',
            'origin_content'       => 'required'
        );
        $validator = \Validator::make(\Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return \Redirect::to('admin/delivery')
                ->withErrors($validator)
                ->withInput(\Input::all());
        } else {
            // store
            $backend = new \Backend;
            $backend->title = \Input::get('title');
            $backend->url = \Input::get('url');
            $backend->origin_content = \Input::get('origin_content');
            $backend->is_available = \Input::get('is_available') == 1 ? true : false;
            $backend->touch();
            $backend->save();
            // redirect
            $id = \Session::get('id');
            \OperatorLog::saveItem($id, "新增 " . \Input::get('title') . " 網站");
            \Session::flash('message', 'Successfully created!');
            return \Redirect::to('admin/delivery');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        //
        $layout = 'layout.basic';
        $backend = \Backend::find($id);

        return \View::make('front.autoPage')
            ->withBackend($backend);
    }
    
    public function getCheckUpdate()
    {
        $id = \Input::get("id");
        $backend = \Backend::findorFail($id);
        $backend->is_available = \Input::get('is_available') == "true" ? true : false;
        $backend->touch();
        if($backend->save()) {
            $id = \Session::get('id');
            \OperatorLog::saveItem($id, "更新 " . $backend->title . " 網站");
            return "更新成功";
        } else {
            return "更新失敗";
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
        $backend = \Backend::find($id);

        return \View::make('delivery::edit')
            ->with('_CONST', $this->_CONST)
            ->withBackend($backend);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        //
        $rules = array(
            'url'       => 'required',
            'origin_content'       => 'required'
        );
        $validator = \Validator::make(\Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return \Redirect::to('admin/delivery')
                ->with('_CONST', $this->_CONST)
                ->withErrors($validator)
                ->withInput(\Input::all());
        } else {
            // store
            $backend = \Backend::findorFail($id);
            $backend->title = \Input::get('title');
            $backend->url = \Input::get('url');
            $backend->origin_content = \Input::get('origin_content');
            $backend->is_available = \Input::get('is_available') == 1 ? true : false;
            $backend->touch();
            $backend->save();

            $id = \Session::get('id');
            \OperatorLog::saveItem($id, "更新 " . \Input::get('title') . " 網站");
            // redirect
            return \Redirect::route('admin.delivery.index');
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }

    public function getBack()
    {
        return \Redirect::back();
    }
}
