<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBackendsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		//
		Schema::create('backends', function($table)
		{
			$table->increments('id');
			$table->string('title')->unique();
			$table->string('url')->unique();
			$table->boolean('is_available');
            $table->longText('origin_content');

			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		//
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('backends');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
	}

}
