@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
@stop

@section('content')
<div class="row-fluid">
    <div>
        <h4 class="nametag">{{ $_CONST['title'] }}</h4>
        <hr>
        <div class="span10 offset1">
            {{ Form::open(array('action'=> 'admin.delivery.store', 'files'=>true, 'class'=>'form-horizontal well'))}}
                @if($errors->has())
                                <div class="alert alert-warning" role="alert">{{ $errors->first() }}</div>
                @endif

            <div class="form-group ">
                <label class="col-sm-2 control-label">標題：</label>
                <div class="col-sm-10">
                    {{ Form::text('title', null, array('class' => 'form-control'))}}
                </div>
            </div>
            <div class="form-group ">
                <label class="col-sm-2 control-label">網址：</label>
                <div class="col-sm-10">
                    {{ Form::text('url', null, array('class' => 'form-control'))}}
                </div>
            </div>
            <div class="form-group ">
                <label class="col-sm-2 control-label">文章內容：</label>
                <div class="col-sm-10">
                    {{ Form::textarea('origin_content', null, array('class' => 'form-control'))}}
                </div>
            </div>
            <div class="form-group ">
                <label class="col-sm-2 control-label">呈現：</label>
                <div class="col-sm-10">
                    {{ Form::checkbox('is_available', true, array('class' => 'form-control'))}}
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-2 control-label"></label>
                <div class="col-sm-10">
                    <input type="submit" name="" value="儲存" class="btn btn-success"  />
                    <a href="{{URL::previous()}}" class="btn btn-default">回上頁 </a>
                </div>
            </div>
            {{ Form::close()}}
            <input type="hidden" class="hidden" id="change-index"/>
        </div> <!-- span10 offset1 -->
    </div>
</div>

    <script>
        @include('Myadmin::js.ckeditor', array(
            'target' => 'origin_content',
        ))
    </script>
@stop
