@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
<script>
    $(document).ready(function(){
        $("[name=is_available]").change(function(){
            var obj = {"is_available" : $(this).prop("checked"), "id": $(this).parents("tr").data("id")}
                $.get( "{{ URL::to('admin/delivery/check-update') }}", obj , function(str) {
                    alert(str);
            });
        });
    });
</script>
<style>
    [name=is_available] {
        width:12px;
    }
</style>
@stop

@section('content')
<div class="row-fluid">
    <div>
        <h4 class="nametag">{{ $_CONST['title'] }}</h4>
        <hr>
                <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@create')}}" class="btn btn-primary" ><i class="icon-ok-circle"></i>新增</a>
        <hr>
        <div class="span10 offset1">
            <table class="table table-bordered">
                <tr>
                    <th>標題</th>
                    <th>網址</th>
                    <th>內容</th>
                    <th>更新時間</th>
                    <th>編輯</th>
                    <th>前端是否呈現</th>
                </tr>
                @foreach ($backends as $backend)
                <tr data-id={{ $backend->id }}>
                    <td>{{{ $backend->title}}}</td>
                    <td>{{{ $backend->url}}}</td>
                    <td>{{ $backend->origin_content }}</td>
                    <td>{{{ $backend->updated_at }}}</td>
                    <td>
                <a href="{{ URL::to('admin/delivery/'.$backend->id) }}" class="btn btn-primary">檢閱</a>
                <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@edit', $backend->id)}}" class="btn btn-info" ><i class="icon-ok-circle"></i>編輯</a>
                    </td>
                    <td>
                {{ Form::checkbox('is_available', 1, $backend->is_available, array('class' => 'form-control'))}}
                    </td>
                </tr>
                @endforeach
            </table>
        </div> <!-- span10 offset1 -->
    </div>
</div>
@stop
