<?php namespace Bee040811\HomeManagement\Controllers;

use Illuminate\Support\ServiceProvider;

class HomeManagementController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';
    //protected $layout = 'bonus::layouts.basic';
    
    public function __construct()
    {
        $routeName = \Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = \Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));

        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;
        $this->_CONST["title"] = "首頁管理系統";
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST['CONTROLLER_ACTION'] = $routeAction;
    }

    /* splay a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        return $this->pageShow();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }
    
    public function postEdit()
    {
    }

    private function pageShow() 
    {
//        $home = \Home::find(1);
		$home = \Home::all();
        $slides = \HomeSlide::all();

        return \View::make('home-management::edit')
            ->with('_CONST', $this->_CONST)
            ->withHome($home[0])
            ->withSlides($slides);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        // validate
        // read more on validation at http://laravel.com/docs/validation
        // redirect
        return $this->pageShow();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
        return $this->pageShow();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $rules = array(
            'image1'       => 'mimes:jpeg,bmp,png',
            'image2'       => 'mimes:jpeg,bmp,png'
        );

        $validator = \Validator::make(\Input::all(), $rules);
        // process the image type
        if ($validator->fails()) {
            $home = \Home::find($id);
            $slides = \HomeSlide::all();
            return \View::make('home-management::edit')
                ->with('_CONST', $this->_CONST)
                ->withHome($home)
                ->withErrors($validator)
                ->withInput(\Input::all())
                ->withSlides($slides);
        }

        // slide save
        $files = \Input::file('slide');
        $links = \Input::get('url');
        $ids = \Input::get('ids');
        $count = 0;
		
		if(!isset($files))
			$files = array();
        foreach ($files as $file){
            $validator = \Validator::make(
                array('file' => $file),
                array('file' => 'mimes:jpeg,bmp,png')
            );
		
            if ($validator->fails()) {
                $home = \Home::find($id);
                $slides = \HomeSlide::all();
                return \View::make('home-management::edit')
                    ->with('_CONST', $this->_CONST)
                    ->withHome($home)
                    ->withErrors($validator)
                    ->withInput(\Input::all())
                    ->withSlides($slides);
            }

            $image = "";
            if(\File::Exists($file)){
                $dest = img_upload_path();
                $originalName = md5(time());
                $r = rand(1,999);
                $originalName = $originalName.$r;
                $file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
                $image = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
            }
            if($ids[$count] == -1) { 
                $slide = new \HomeSlide;
                $slide->image = $image;
                $slide->link = $links[$count];
                $slide->timestamps = false;
                $slide->save();
            } else {
                $slide = \HomeSlide::findorFail(intVal($ids[$count]));
                if($image != "") {
                    $slide->image = $image;
                }

                $slide->link = $links[$count];
                $slide->timestamps = false;
                $slide->save();
            }

            $count++;
        }


        $names = array();
        for($i = 1; $i <= 2; $i++) {
            $file = \Input::file('image'. strval($i));
            $name = "";
            if(\File::Exists($file)){
                $dest = img_upload_path();
                $originalName = md5(time());
                $r = rand(1,999);
                $originalName = $originalName.$r;
                $file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
                $name = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
            }
            array_push($names, $name);
        }

        $home = \Home::findorFail($id);
        
        if($names[0] != "") {
            $home->image1 = $names[0];
        }

        if($names[1] != "") {
            $home->image2 = $names[1];
        }

        $home->link1 = \Input::get('link1');
        $home->link2 = \Input::get('link2');
        $home->tag = \Input::get('tag');

        $home->save();

        // redirect
        \Session::flash('message', 'Successfully created!');
        
        $home = \Home::find($id);
        $slides = \HomeSlide::all();

        return \View::make('home-management::edit')
            ->with('_CONST', $this->_CONST)
            ->withHome($home)
            ->withSlides($slides);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
        //return $id;
        \HomeSlide::destroy($id);
        return "success" . $id;
    }


    public function getBack()
    {
        return \Redirect::back();
    }

	public function getReports($id)
	{
		$time = date('Y-m-d');
		$users = \BloggerUser::all();
		$looker = array();
		$looker[0] = "依照LOOKER";
		foreach ($users as $usr){
			$looker[$usr->id] = $usr->name;
		}
//		return $looker;

		$lookers_data= array();
	foreach($users as $user){
		$lookers_data[$user->id][]=$time;
		$lookers_data[$user->id][]=$user->id;
		$lookers_data[$user->id][]=$user->name;
		$lookers_data[$user->id][]= \DB::table('action_log')->where('blogger_id',$user->id)->where('action','LIKE')->count();
		$lookers_data[$user->id][]= \DB::table('article_comments')->where('blogger_id',$user->id)->count();
		$lookers_data[$user->id][]= \DB::table('action_log')->where('blogger_id',$user->id)->where('action','SHARE')->count();
		$lookers_data[$user->id][]= count(\DB::table('action_log')->where('blogger_id',$user->id)->where('action','BROWSE')->select('user_id')->distinct()->get());
		$lookers_data[$user->id][]= \DB::table('action_log')->where('blogger_id',$user->id)->where('action','BROWSE')->count();
		$lookers_data[$user->id][]= \DB::table('action_log')->where('blogger_id',$user->id)->where('action','goWeb')->count();
		$lookers_data[$user->id][]= \DB::table('action_log')->where('blogger_id',$user->id)->where('action','goShop')->count();
		$lookers_data[$user->id][]= \DB::table('action_log')->where('blogger_id',$user->id)->where('action','goStore')->count();
		$lookers_data[$user->id][]= 0;
	}
//	return $lookers_data;

		return \View::make('home-management::reports')
			->withLookername($looker)
			->withLookers($users)
			->withData($lookers_data)
			->with('_CONST',$this->_CONST);
	}

	public function getReportsData()
    {
        // id == 0 means all
        
        $time= date('Y-m-d H:m:s');
		$from = \Input::get('from');
        $to = \Input::get('to');
        $id = \Input::get('blogger-id');

        if($to == "") {
            $to = $time;
        }

		$users = \BloggerUser::all();
		$looker = array();
        $looker[0] = "依照LOOKER";

        foreach ($users as $usr){
			$looker[$usr->id] = $usr->name;
		}

        $lookers_data= array();

        foreach($users as $user){
            if($id != 0 && $id != $user->id) {
                continue;
            }
            $lookers_data[$user->id][]= $time;
            $lookers_data[$user->id][]=$user->id;
            $lookers_data[$user->id][]=$user->name;
            $lookers_data[$user->id][]= \DB::table('action_log')
                ->where('blogger_id',$user->id)
                ->where('action','LIKE')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->count();
            $lookers_data[$user->id][]= \DB::table('article_comments')
                ->where('blogger_id',$user->id)
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->count();
            $lookers_data[$user->id][]= \DB::table('action_log')
                ->where('blogger_id',$user->id)
                ->where('action','SHARE')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->count();
            $lookers_data[$user->id][]= count(\DB::table('action_log')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->where('blogger_id',$user->id)->where('action','BROWSE')->select('user_id')->distinct()->get());
            $lookers_data[$user->id][]= \DB::table('action_log')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->where('blogger_id',$user->id)->where('action','BROWSE')->count();
            $lookers_data[$user->id][]= \DB::table('action_log')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->where('blogger_id',$user->id)->where('action','goWeb')->count();
            $lookers_data[$user->id][]= \DB::table('action_log')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->where('blogger_id',$user->id)
                ->where('action','goShop')->count();
            $lookers_data[$user->id][]= \DB::table('action_log')
                ->where('created_at' , '>=', $from)
                ->where('created_at' , '<=', $to)
                ->where('blogger_id',$user->id)->where('action','goStore')->count();
            $lookers_data[$user->id][]= 0;
            $lookers_data[$user->id][]= $from;
            $lookers_data[$user->id][]= $to;
        }

        return $lookers_data;
    }
}
