<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHomeTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		//
        if(!Schema::hasTable('myadmin_home')) {
            Schema::create('myadmin_home', function($table){
                $table->increments('id');
                $table->string('image1')->nullable();
                $table->string('link1')->nullable();
                $table->string('image2')->nullable();
                $table->string('link2')->nullable();
                $table->string('tag')->nullable();
            });
        }

        Schema::table('myadmin_home', function($table){
            $table->timestamps();
        });
        
        if(!Schema::hasTable('myadmin_home_slide')) {
            Schema::create('myadmin_home_slide', function($table){
                $table->increments('id');
                $table->string('image');
                $table->string('link');
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
    {
        /*
        Schema::table('myadmin_home', function($table){
            $table->dropColumn("updated_at");
            $table->dropColumn("created_at");
        });
         */
		//
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
		Schema::dropIfExists('myadmin_home');
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
	}

}
