@extends('Myadmin::layout.basic')

@section('header')
<script>
    </script>
    <style>
        .btn-my{  
            background: #006633;
            width: 100px;  
            height: 100px;  
            -moz-border-radius: 50%;  
            -webkit-border-radius: 50%;  
            border-radius: 50%;  
        }  
        .btn-my:hover {  
            background: #BFEC3E;   
            color:#e75616;  
        }  

        .slide-model {
            display:none;
        }

        .image {
            width:100%;
        }
        .img_show {
            width:150px;
        }   
    </style>
@stop

@section('content')
<div class="row-fluid">
    <div>
        <h4 class="nametag">{{ $_CONST['title'] }}</h4>
        <hr>
        <div class="span10 offset1">
        {{ Form::model($home, array(
            'route'=> array($_CONST["CONTROLLER_ROUTE"].'.update', $home->id),
            'class'=>'form-horizontal well',
            'method' => 'put',
            'files' => true
        ))}}
            @if($errors->has())
                <div class="alert alert-warning" role="alert">{{ $errors->first() }}</div>
            @endif
            <div class="slide-content">
                @foreach($slides as $slide)
                    <div class="form-group" data-id="{{ $slide->id }}">
                        <label class="col-sm-2 control-label">首頁Slide圖片</label>
                        <div class="col-sm-2">
                            <input class="hidden" name="ids[]" type="hidden" value="{{$slide->id}}">
                            <input class="image" name="slide[]" type="file">
                            @if($slide->image != "")
                            <img style="width:150px;height:150px" class="img_show"  class="preview" src="{{ img_upload_url($slide->image) }}">
                            @else
                            <img style="width:150px;height:150px" class="img_show"  class="preview" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
                            @endif
                        </div>
                        <label class="col-sm-2 control-label">超連結網址：</label>
                        <div class="col-sm-3">
                            {{ Form::text('url[]', $slide->link, array('class' => 'form-control'))}}
                        </div>
                        <div class="col-sm-3">
                            <a class="btn btn-danger delete">刪除</a>
                        </div>
                    </div>
                    <hr>
                @endforeach
            </div>

            <button type="button" id="btnplus" class="btn btn-my glyphicon glyphicon-plus" style="margin-left:50%"></button>
            

            <div class="form-group">
                <label class="col-sm-2 control-label">側邊海報圖片</label>
                <div class="col-sm-2">
                    <input class="image" name="image1" type="file">    
                    @if($home["image1"] != "") 
                    <img class="img_show"  class="preview" src="{{{ img_upload_url($home["image1"])}}}">
                    @else 
                    <img class="img_show"  class="preview" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
                    @endif
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-2 control-label">側邊海報連結</label>
                <div class="col-sm-10">
                    {{ Form::text('link1', null, array('class' => 'form-control')) }}
                </div>
            </div>

            <!-- 海報 -->
            <div class="form-group">
                <label class="col-sm-2 control-label">側邊海報圖片</label>
                <div class="col-sm-2">
                    <input class="image" name="image2" type="file">
                    @if($home["image2"] != "") 
                    <img class="img_show"  class="preview" src="{{{ img_upload_url($home["image2"])}}}">
                    @else 
                    <img class="img_show"  class="preview" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
                    @endif
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-2 control-label">側邊海報連結</label>
                <div class="col-sm-10">
                    {{ Form::text('link2', null, array('class' => 'form-control')) }}
                </div>
            </div>
            
            <div class="form-group">
                <label class="col-sm-2 control-label">Tag名稱</label>
                <div class="col-sm-10">
                    {{ Form::text('tag', null, array('class' => 'form-control')) }}
                </div>
            </div>

            <div class="form-group">
                <label class="col-sm-2 control-label"></label>
                <div class="col-sm-10">
                    <input type="submit" name="" value="儲存" class="btn btn-success"  />
                    <a href="{{URL::previous()}}" class="btn btn-default">回上頁 </a>
                </div>
            </div>
            {{ Form::close()}}
            <input type="hidden" class="hidden" id="change-index"/>
        </div> <!-- span10 offset1 -->
    </div>
</div>

<div class="slide-model">
    <div class="form-group">
        <label class="col-sm-2 control-label">首頁Slide圖片</label>
        <div class="col-sm-2">
            <input class="hidden" name="ids[]" type="hidden" value="-1">
            <input class="image" name="slide[]" type="file">
            <img style="width:150px;height:150px" class="img_show"  class="preview" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
        </div>
        <label class="col-sm-2 control-label">超連結網址：</label>
        <div class="col-sm-3">
            {{ Form::text('url[]', null, array('class' => 'form-control'))}}
        </div>
        <div class="col-sm-3">
            <a class="btn btn-danger delete">刪除</a>
        </div>
    </div>
    <hr>
</div>
<script language="JavaScript">

    $(document).ready(function(){
        loadImageInitial();

        $("#btnplus").click(function(){
            var content = $(".slide-model").html();
            $(".slide-content").append(content);
            loadImageInitial();
        });
    });

    function loadImageInitial() {
        $(".image").change(function(event) {
             var inputFiles = this.files;
             
             if(inputFiles == undefined || inputFiles.length == 0) {
                alert("no file");
             }
             
             var inputFile = inputFiles[0];
             var preview = $(this).next();
             var reader = new FileReader();

             reader.onload = function(){
                 preview.attr("src", reader.result);
             };

             reader.onerror = function(event) {
                 alert("I AM ERROR: " + event.target.error.code);
             };

             reader.readAsDataURL(inputFile);
        });
        $(".delete").click(function(){
            var id = $(this).parents(".form-group").data("id");
            var url = "{{  URL::to('admin/home/') }}" +"/"+ id;
            $.ajax({
                url: url,
                type: 'DELETE',
                data: {"id":id},
                success: function(result) {
                    // Do something with the result
                    location.href = "{{ URL::to('admin/home/1/edit') }}";
                 }
             });
        })
    }
</script>
@stop
