@extends('Myadmin::layout.basic')

@section('header')
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
<script src="../../../js/Export-Html-Table-To-Excel-Spreadsheet-using-jQuery-table2excel/src/jquery.table2excel.js"></script>
<script src="../../../js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<link rel="stylesheet" href="{{asset('css/bootstrap-datetimepicker.min.css')}}" />
@stop

@section('content')
<style type="text/css" media="screen">
	.btn-custom{  
		width: 150px;  
    } 

    .table-btn td{
        padding:10px;
    }
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }

        #bonus-form {
            text-align:center;
        }
        
        #bonus-form td {
            padding:10px;
        }
</style>

    <div class="input-prepend input-append">
    </div>
    <h4 class="nametag">報表分析</h4>
	<hr>

		<div class="row">	
            <div class="col-xs-8 col-sm-8 col-md-8">
        				<label class="col-sm-2  form-group">日期範圍</label>
						<div id="datetimepicker1" class="col-sm-4 input-append date">  
		    				<input type="text" name="from_date"></input>  
	    		    		<span class="glyphicon glyphicon-calendar add-on btn" data-time-icon="icon-time" data-date-icon="icon-calendar"></span>  
							~
		    			</div>
						<div id="datetimepicker2" class="col-sm-4 input-append date">  
    						<input type="text" name="to_date"></input>  
	        				<span class="glyphicon glyphicon-calendar add-on btn" data-time-icon="icon-time" data-date-icon="icon-calendar"></span>  
				    	</div>
						<hr>
						<div class="col-sm-4 form-group">
							{{ Form::select('lookername', $lookername, null,  array('class' => 'form-control')) }}		
						</div>
			</div>

			<div class="col-md-4 col-sm-4 col-xs-4 pull-right" style="margin-top:10px">
				<div class="input-group">
					<input type="text" class="form-control" placeholder="訂單編號 , email" id="search_input">
					<span class="input-group-btn">
						<button class="btn btn-default" type="button" id="search">Seach</button>
					</span>
				</div>
				<hr>
				<div class="input-group">
					<span class="input-group-btn">
						<button class="btn btn-success" type="button" id="download">下載EXCEL報表</button>
					</span>
				</div>
			</div>

		</div>
		<hr>

    <table class="table table-bordered" id="product-table">
		<thead>
			<tr>
				<th>日期</th>
				<th>Looker ID</th>
				<th>Looker名稱</th>
				<th>累積按讚數</th>
				<th>累積留言數</th>
				<th>累積分享數</th>
				<th>累積到站人數</th>
				<th>累積瀏覽人數</th>
				<th>導入官方網站瀏覽數</th>
				<th>導入實體店舖</th>
				<th>導入商城瀏覽數</th>
				<th>導入商城累積購買金額</th>
			</tr>
		</thead>
		<tbody>

		@foreach ($lookers as $looker)
			<tr>
				<td class="td-date" data-date="{{$data[$looker->id][0]}}">{{$data[$looker->id][0]}}</td>
				<td>{{$data[$looker->id][1]}}</td>
				<td>{{$data[$looker->id][2]}}</td>
				<td>{{$data[$looker->id][3]}}</td>
				<td>{{$data[$looker->id][4]}}</td>
				<td>{{$data[$looker->id][5]}}</td>
				<td>{{$data[$looker->id][6]}}</td>
				<td>{{$data[$looker->id][7]}}</td>
				<td>{{$data[$looker->id][8]}}</td>
				<td>{{$data[$looker->id][9]}}</td>
				<td>{{$data[$looker->id][10]}}</td>
				<td>{{$data[$looker->id][11]}}</td>
			</tr>
		@endforeach
{{--
        @foreach ($transactions as $transaction) 
        <tr data-id={{$transaction->id}}>
            <td style="width:129px font-size:12px" id="td_pro_title">{{ $transaction->order_code }}</td>
            <td style="width:129px font-size:12px" id="td_pro_status">{{ $transaction->status }}</td>
            <td style="width:129px font-size:12px" id="td_pro_email">{{ $transaction->mail }}</td>
		    <td style="width:100px font-size:12px">{{ $transaction->money }}</td>
		    <td style="width:100px font-size:12px">{{ $transaction->amount }}</td>

            <td style="width:100px font-size:12px">
                {{ Form::open(array(
                    'url'=>array('admin/product/shopdestroy', $transaction->id),
                    'method' => 'get')
                )}}
                <a href="" class="btn btn-primary" data-toggle="modal" data-target="#wsModal" name="edit">
                    <span class="glyphicon glyphicon-pencil"></span>
                    編輯
                </a>
                {{ Form::close()}}
            </td>

        </tr>
        @endforeach
--}}
		</tbody>
    </table>
		<input type="hidden" value="" class="id-change"></input>

	<!-- Modal -->
	<div id="wsModal" class="modal fade" role="dialog">
		<div class="modal-dialog">

		<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">修改數量</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label class="control-label col-sm-2">原本數量</label>
						<div class="col-sm-4">
							{{ Form::label('amount', ' ', array('class' => 'form-control' , 'id' => 'amountid'))}}
						</div>
					</div> <br><br>
					<div class="form-group">
						<label class="control-label col-sm-2">修改數量</label>
						<div class="col-sm-4">
							{{ Form::number('fix_amount', ' ', array('class' => 'form-control' , 'id' => 'fix_amount'))}}
						</div>
					</div> <br><br>
				</div>
				<div class="modal-footer">
					<button class="btn btn-success" id="amount_submit" data-dismiss="modal">submit</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			</div>

		</div>
	</div>

<script type="text/javascript" charset="utf-8">
        function getToday() {
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth()+1; //January is 0!

            var yyyy = today.getFullYear();
            if(dd<10){
                dd='0'+dd
            } 
            if(mm<10){
                mm='0'+mm
            }

            return yyyy + '-' + mm + '-' + dd;
        }

        $(document).ready(function(){
            var base_url = "{{route('admin.product.index')}}";
			var c_array = [];
            var id;
            var time = getToday();

            $("#search").click(function(){
                var from = $("input[name=from_date]").val();
                var to = $("input[name=to_date]").val();
                
                $.get("{{URL::to('admin/home/reports-data/')}}", {
                    "from" : from,
                    "to" : to,
                    "blogger-id" : $("[name=lookername]").val()
                }, function(data) {
                    $("#product-table tbody").html("");
                    for(var key in data) {
                        $("#product-table tbody").append(
                            $("<tr/>", {"id":"key-" + key})
                        );

                        var date1 = data[key][12].split(" ")[0];
                        var date2 = data[key][13].split(" ")[0];
                        var output = date1 +"～"+ date2;
                        if(date1 == "") {
                            output = date2;
                        }

                        $("#key-"+key).append(
                            $("<td/>").html(output)
                        );

                        for(var i = 1; i < data[key].length-2; i++) {
                            $("#key-"+key).append(
                                $("<td/>").html(data[key][i])
                            );
                        }
                    }
                });

                /*
                if(to == "") {
                    to = getToday();
                }

                $("#product-table tbody>tr").hide();
                $(".td-date").each(function() {
                    if($(this).data("date") >= from && $(this).data("date") <= to) {
						$(this).parent().show();
                    }
            });
                 */
            });

            $("select[name=status]").change(function(){
				if($("select[name=status] option:selected").text() == "全部狀態")
					$("#product-table tbody>tr").show();
				else
				{
					$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_status:contains-ci('"+$("select[name=status] option:selected").text()+"')").parent("tr").show();
				}
            });

			$("#search_input").keyup(function(){
				// When value of the input is not blank
				if( $(this).val() != ""){
				// Show only matching TR, hide rest of them
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).val()+"')").parent("tr").show();
					$("#product-table #td_pro_email:contains-ci('"+$(this).val()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});

			$("a[name=edit]").click(function(){
				id = $(this).closest("tr").data("id");
				for (var i=0 ; i<transactions.length ; i++){
					if(transactions[i]['id'] == $(this).closest("tr").data("id"))
						$("#amountid").text(transactions[i]['amount']);
				}
			});

			$("#amount_submit").click(function(){
				window.location = "{{ URL::to('admin/product/instock') }}" + "/" + id + "/" + $("#fix_amount").val();
			});

	$("#download").click(function() {
		$("#product-table").table2excel({
			exclude: $("tr:hidden"),
		    name: "Excel Document Name",
			filename: "reports"
		  });
//    window.open('data:application/vnd.ms-excel,' +  encodeURIComponent($('#product-table').html()) );
 //   e.preventDefault();
	});

        });

		$("#datetimepicker1, #datetimepicker2").datetimepicker({
			language: 'en',
			pickTime: true,
			pickDate: true,
			format: 'yyyy-MM-dd hh:mm:ss',
		});

		$.extend($.expr[":"],
		{
			"contains-ci": function(elem, i, match, array)
			{
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});

    </script>
@stop

