<?php namespace Bee040811\Jsonapi\Controllers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\ModelNotFoundException; // top of the page

class JsonapiController extends \BaseController {


    public function __construct()
    {
    }

    // products api 
    // /products/{id}
    //
    public function getProducts($id = NULL)
    {
		$obj;
		$count = 0;
		$bonusoption = array();
		$bonusvalue = array();


        foreach (\BonusCategories::all() as $bonus) {
            $bonusoption[$bonus->id] = $bonus->category;
			$bonusvalue[$bonus->id] = $bonus->value;
        }

        if($id == NULL) {
			foreach (\Product::all() as $pro){
                $productDetail = \ProductDetail::where("product_id", "=", $pro->id)->first();
				if ($productDetail["image"] != null)
	                $obj["img_path"] = asset($productDetail["image"]);
				else
					$obj["img_path"] = "";
				$obj["special_case"] = $pro->special_case;
				$obj["title"] = $pro->title;
				$obj["format"] = $pro->format;	
				$obj["video_url"] = $pro->video_url;
				$obj["description"] = $pro->description;
				$obj["selling_price"] = $pro->selling_price;
				$obj["price"] = $pro->price;
				$obj["bonus_category"] = $bonusoption[$pro->bonus_category_id];
				$obj["bonus_value"] = $bonusvalue[$pro->bonus_category_id];
				$obj["available_amount"] = $pro->available_amount;
				$obj["stock_amount"] = $pro->stock_amount;

				$products[$count] = $obj;
				$count++;
			}
		} 
		else {
//			echo \Product::find($id);
//			foreach (\Product::find($id) as $pro){
			$pro = \Product::find($id);
			$categories = \ProductCategories::find($pro->category_id);

			if($categories->name == "集量商品" || $categories->name == "限時商品"){
				$currentTime = new \DateTime;
				$closeDate = new \DateTime($pro->close_date);				
				$obj["time_left"] = (string)($closeDate->getTimestamp() - $currentTime->getTimestamp());
			}
			if($categories->name == "集量商品"){
				$obj["complete_rate"] = $pro->deal_status/$pro->deal_baseline;
			}

			$productDetail = \ProductDetail::where("product_id", "=", $pro->id)->first();
			if ($productDetail["image"] != null)
				$obj["img_path"] = asset($productDetail["image"]);
			else
				$obj["img_path"] = "";
			if($categories->name != "集量商品" && $categories->name != "限時商品")
				$obj["special_case"] = $pro->special_case;

			$obj["title"] = $pro->title;
			$obj["format"] = $pro->format;	
			$obj["video_url"] = $pro->video_url;
			$obj["description"] = $pro->description;
			$obj["selling_price"] = $pro->selling_price;
			$obj["price"] = $pro->price;
			$obj["bonus_category"] = $bonusoption[$pro->bonus_category_id];
			$obj["bonus_value"] = $bonusvalue[$pro->bonus_category_id];
			$obj["available_amount"] = $pro->available_amount;
			$obj["stock_amount"] = $pro->stock_amount;

			$products[$count] = $obj;
			$count++;
//			}
        }
//		$t = date('Y-m-d H:m:s');
//		$t = new \DateTime;
//		print_r($pro->close_date);
//		return (string)$t;
		return $products;
    }

    // categories api 
    // /categories/{id}
    //
    public function getCategories($id = NULL)
    {  
        $option = array();
        $products = array();
        $bonusoption = array();
        $obj;
        $orders;
        $count = 0;

        foreach (\BonusCategories::all() as $bonus) {
            $bonusoption[$bonus->id] = $bonus->category;
        }

        try {
            $categories = \ProductCategories::findOrFail($id);
            if($categories->name == "集量商品" || $categories->name == "限時商品"){
                $orders = \Product::orderBy("close_date","asc")->where("close_date", "!=", "0000-00-00 00:00:00")->get();
                //			echo $orders;
            }
            else{
                $orders = \Product::orderBy("updated_at","desc")->get(); 
            }
            //		echo $categories;
            foreach ($orders as $pro){
                if($pro->category_id == $id){
                    $productDetail = \ProductDetail::where("product_id", "=", $pro->id)->first();

                    //$obj = $pro;
                    $obj["product_code"] = $pro->product_code;
                    $obj["title"] = $pro->title;
                    $obj["format"] = $pro->format;
                    $obj["price"] = $pro->price;
                    $obj["selling_price"] = $pro->selling_price;
                    $obj["available_amount"] = $pro->available_amount;
                    $obj["stock_amount"] = $pro->stock_amount;
                    $obj["special_case"] = $pro->special_case;
                    $obj["bonus"] = $bonusoption[$pro->bonus_category_id];
                    $obj["is_available"] = $pro->is_available;
                    $obj["is_available"] = $pro->is_available;
                    $obj["type"] = $pro->type;
                    $obj["img_path"] = asset($productDetail["image"]);
                    $products[$count] = $obj;
                    $count++;
                }
            }
            return $products;
        } catch(ModelNotFoundException $exception) {
            return $products;
        }
    }

    // test json parse
    public function getMethod($id = NULL)
    {
        $str = file_get_contents("http://106.187.42.25/new-bee/new-nineten/public/jsonapi/categories/".$id);
        $obj = json_decode($str);
        var_dump($obj);
    }
}
