<?php namespace Lucaswei\AioPayment\Facades;

use Illuminate\Support\Facades\Facade;
use Config;
use MyadminProduct;

class Aio extends Facade
{
    /* */
    protected static function getFacadeAccessor() { return 'supyo'; }

    /*
     * parse products from Cookie and return an objectlize structure
     *
     * array(
     *     "item serial number1" => k,
     *     "item serial number2" => r,
     *     ...
     * )
     *
     * TODO: handle crashed cart string
     */
    public static function getCart()
    {
        return new Cart;
    }

    public static function formalizeTradeNo($digit)
    {
        return Config::get("aio-payment::app.tradeNoPrefix").sprintf("%07d", $digit);
    }

    public static function unformalizeTradeNo($tradeNo)
    {
        $prefix_length = strlen(Config::get("aio-payment::app.tradeNoPrefix"));
        return (int)substr($tradeNo, $prefix_length);
    }

    public static function getTransactionStatus($statusCode)
    {
        switch($statusCode){
            case 1:
                return "下單中";
            case 2:
                return "付款完成";
            default:
                return "不明，請聯絡管理員";
        }
    }

}

/**
 *  Collection of Cart products
 *
 *  accessable data:
 *      $this->serialCart
 *      $this->products
 *      $this->readable_list
 *      $this->total_price
 *
 **/
class Cart
{
    
    function __construct()
    {
        $this->serialCart = $_COOKIE["cart"];
        $this->products = json_decode($this->serialCart);

        $this->readable_list = "";
        $this->total_price = 0;
        foreach ($this->products as $raw) {
            $product = MyadminProduct::find($raw->id);

            $this->readable_list .= "{$product->title}*{$raw->amount}#";
            $this->total_price += $product->price * $raw->amount;
        }
        substr($this->readable_list, 0, -1);
    }

}
