<?php namespace Lucaswei\AioPayment;

use Illuminate\Support\ServiceProvider;

class AioPaymentServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Bootstrap the application events.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->package('lucaswei/aio-payment');

        $loader = \Illuminate\Foundation\AliasLoader::getInstance();
        $loader->alias('Aio', 'Lucaswei\AioPayment\Facades\Aio');
	}

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
        $this->app['AioPayment'] = $this->app->share(function($app){
            return new Aio;
        });
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

}
