<?php

use Monolog\Logger;
use Monolog\Handler\StreamHandler;

define("STATUS_CONFIRM", 1);
define("STATUS_PAID", 2);

/**
 * 
 **/
class AioController extends BaseController
{

    public function getIndex()
    {
    }

    /*
     * Step 2:
     *  Consumer confirm the buying process and check the product list are right
     *  ** Meas that wont have permision to change the product name and number **
     */
    public function getStep2()
    {
        echo "<html><body><form method='post' action=\"".action("AioController@postStep2")."\">";
        echo "name".Form::text('name', "小明");
        echo "email".Form::text('email', "mymail@mail.com");
        echo "phone".Form::text('phone', "0912345678");
        echo "address".Form::text('address', "台北火車站附近");
        echo "<input type='submit'>";
        echo "</form></body></html>";
        return;
    }
    public function postStep2()
    {
        $input = Input::all();
        $validator = Validator::make(
            $input,
            array(
                'name' => 'required',
                'email' => 'required|email',
                'phone' => 'required',
                'address' => 'required',
            )
        );

        if ($validator->passes()) {
            // TODO: check all products are avaliable
            //check the products are all valid and in-stock
            $customer = MyadminConsumer::firstOrCreate(array("email" => $input["email"]));
            $customer->name = $input["name"];
            $customer->phone = $input["phone"];
            $customer->address = $input["address"];
            $customer->save();

            $userId = $customer->id;

            $cart = Aio::getCart();

            // create a new transaction
            $transaction = new MyadminTransaction;
            $transaction->user_id  = $userId;
            $transaction->products = $cart->serialCart;
            $transaction->readable_products = $cart->readable_list;
            $transaction->price    = $cart->total_price;
            $transaction->status   = STATUS_CONFIRM;
            $transaction->comment  = "name:{$input["name"]}\nemail:{$input["email"]}\nphone:{$input["phone"]}\naddress:{$input["address"]}\n";
            $transaction->save();
            
            Session::put("order_number", $transaction->id);
            return Redirect::action("AioController@getOrder");
        }else if ($validator->fails() ) {
            return Redirect::action("AioController@getStep2")->withErrors($validator);
        }else{
            echo "unknown errors";
        }

    }

    public function getOrder()
    {
        // invalid URL access
        if (!Session::has("order_number")) {
            echo "查無等待付款的訂單，請確認後重新執行。";
            return; } $transaction = MyadminTransaction::findOrFail(Session::get("order_number")); 
        $tradeInfo = array(
            "MerchantID" => Config::get("aio-payment::app.MerchantID"),
            "MerchantTradeDate" => date("Y/m/d H:i:s", time()),
            "PaymentType" => "aio", // "aio" must contained in this field

            // trading item list & description
            "ItemName" => $transaction->readable_products,
            "MerchantTradeNo" => Aio::formalizeTradeNo($transaction->id),
            "TradeDesc" => "測試交易描述",
            "TotalAmount" =>$transaction->price,

            "ReturnURL" => action("AioController@postReturn"),
            "ChoosePayment" => Config::get("aio-payment::app.ChoosePayment"),
            "ClientBackURL" => action("HomeController@getCompletion"),
            "NeedExtraPaidInfo" => Config::get("aio-payment::app.NeedExtraPaidInfo"),
        );
        $hashKey = Config::get("aio-payment::app.HashKey");
        $hashIV  = Config::get("aio-payment::app.HashIV");
        $tradeInfo["CheckMacValue"] = $this->checkMacValue($tradeInfo, $hashKey, $hashIV);
        return View::make("aio-payment::redirect")
            ->with("targetURL", Config::get("aio-payment::app.targetURL"))
            ->with('tradeInfo', $tradeInfo);
    }

    public function getSuccess()
    {
        echo "success";
    }

    public function getLog()
    {
        echo "logger";

        $logger = new Logger('Aio callback');
        $logger->pushHandler(new StreamHandler(storage_path().'/logs/aio_callback.log'));

        $logger->addInfo("Logger test");
    }

    /*
     * When Aio payment done the trade,
     * it return the trading status and result through this URL.
     */
    public function postReturn()
    {
        $tradeInfo = Input::all();

        if ($tradeInfo["MerchantID"] != Config::get("aio-payment::app.MerchantID")) {
            $logger = new Logger('Aio callback');
            $logger->pushHandler(new StreamHandler(storage_path().'/logs/aio_callback.log'));

            $logger->addInfo("Wrong MerchantID");
            echo "wrong MerchantID";
            return;
        }
        $hash_mac = $tradeInfo["CheckMacValue"];
        unset($tradeInfo["CheckMacValue"]);

        $hashKey = Config::get("aio-payment::app.HashKey");
        $hashIV  = Config::get("aio-payment::app.HashIV");
        if ($this->checkMacValue($tradeInfo, $hashKey, $hashIV) == strtolower($hash_mac)) {
            $tradeNo = Aio::unformalizeTradeNo($tradeInfo["MerchantTradeNo"]);
            $transaction = MyadminTransaction::findOrFail($tradeNo);

            if ($transaction->response_id == 0) {
                $response = MyadminCredit::create(array());
                $transaction->response_id = $response->id;
            }else {
                $response = $transaction->response;
            }
            $response->payment_date = str_replace( '/', "-", $tradeInfo["PaymentDate"]);
            $response->charge_fee   = $tradeInfo["PaymentTypeChargeFee"];
            $response->tradeNo      = $tradeInfo["TradeNo"];
            $response->gwsr         = $tradeInfo["gwsr"];
            $response->eci          = $tradeInfo["eci"];
            $response->auth_code    = $tradeInfo["auth_code"];
            $response->card4no      = $tradeInfo["card4no"];
            $response->card6no      = $tradeInfo["card6no"];
            //$response->trade_status = $tradeInfo["TradeStatus"];
            $response->save();
            $transaction->status = STATUS_PAID;
            $transaction->save();

            $products = json_decode($transaction->products);
            $consumer = $transaction->consumer;
            $email = $consumer->email;
            $receiver = $consumer->name;

            Mail::send('emails.pay-callback', array('name'=>$consumer->name, 'products' => $products, 'total' => $transaction->price), function($message)
                use ($email, $receiver)
            {
                $message->to($email, $receiver)->subject('感謝您此次於油然而生購物商城消費，您的消費金額已轉帳成功。');
            });
            echo "OK";

        }else {
            $logger = new Logger('Aio callback');
            $logger->pushHandler(new StreamHandler(storage_path().'/logs/aio_callback.log'));

            $logger->addInfo("Wrong mac value");
            $logger->addInfo(print_r($_POST, true));
            echo "wrong mac value";
        }
    }

    /*
     *
     */
    private function checkMacValue($tradeInfo, $hashKey, $hashIV)
    {
        ksort($tradeInfo, SORT_STRING | SORT_FLAG_CASE);

        $hashPlaintext = "HashKey={$hashKey}&";
        foreach ($tradeInfo as $key => $val) {
            $hashPlaintext .= "{$key}={$val}&";
        }
        $hashPlaintext .= "HashIV={$hashIV}";

        $hashPlaintext = str_replace(array(
            '%21',
            '%2A',
            '%28',
            '%29',
        ), array(
            '!',
            '*',
            '(',
            ')',
        ), urlencode($hashPlaintext));
        return md5( strtolower( $hashPlaintext));
    }
}

