<?php

class MyadminAioController extends \BaseController {

    // self defined members
    protected $_CONST;


    public function __construct()
    {
        $this->_CONST = array();
    }
	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
        $transactions = new MyadminTransaction;
        if (Input::has("use_keyword") && Input::has("keyword")) {
            $transactions = $transactions->where('comment', 'like', "%".Input::get("keyword")."%");
        }
        if (Input::has("use_date")) {
            $transactions = $transactions->where("created_at", ">=", Input::get("begin_date"));
            $transactions = $transactions->where("created_at", "<=", Input::get("end_date"));
        }
        if (Input::has("use_status")) {
            $transactions = $transactions->where("status", Input::get("status"));
        }
        return View::make('aio-payment::backend.index')
            ->with('_CONST', $this->_CONST)
            ->withTransactions($transactions->paginate(15));
	}


	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
        $option = array();
        foreach ($this->classModelInstance->all() as $product) {
            $option[$product->id] = $product->title;
        }
        $this->layout->content = View::make('product-management::product.create')
            ->with('_CONST', $this->_CONST)
            ->withOption($option);
	}


	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
        $userInput = Input::all();
        $validator = Validator::make(
            $userInput,
            array(
                'title' => 'required',
                'price' => 'required|alpha_num',
                'image' => 'image'
            )
        );
        if ($validator->passes()) {
            $product = $this->selfModelInstance;
            $product->title = $userInput['title'];
            $product->sub_title = $userInput['sub_title'];
            $product->origin_content = $userInput['origin_content'];
            $product->content = strip_tags($userInput['origin_content']);
            $product->price = $userInput['price'];
            $product->category_id = $userInput['category_id'];
            if (Input::hasFile('image')) {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                $file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());

                $product->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
            }
            $product->save();
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.create')->withErrors($validator);
	}


	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
        $transaction = MyadminTransaction::findOrFail($id);
        return View::make('aio-payment::backend.show')
            ->with('_CONST', $this->_CONST)
            ->withConsumer($transaction->consumer)
            ->withTransaction($transaction);
	}


	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
        $option = array();
        foreach ($this->classModelInstance->all() as $product) {
            $option[$product->id] = $product->title;
        }
        $product = $this->selfModelInstance->findOrFail($id);
        $this->layout->content = View::make('product-management::product.edit')
            ->with('_CONST', $this->_CONST)
            ->withProduct($product)
            ->withOption($option);
	}


	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
        $product = $this->selfModelInstance->findOrFail($id);
        $userInput = Input::all();
        $validator = Validator::make(
            $userInput,
            array(
                'title' => 'required',
                'price' => 'required|alpha_num',
                'image' => 'image'
            )
        );
        if ($validator->passes()) {
            $product->title = $userInput['title'];
            $product->sub_title = $userInput['sub_title'];
            $product->origin_content = $userInput['origin_content'];
            $product->content = strip_tags($userInput['origin_content']);
            $product->price = $userInput['price'];
            $product->category_id = $userInput['category_id'];
            if (Input::hasFile('image')) {
                // TODO remove origin image
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                $file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());

                $product->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
            }
            $product->save();
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.edit', $id)->withErrors($validator);
	}


	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
        $product = $this->selfModelInstance->findOrFail($id);
        if (file_exists($product->img_path)) {
            unlink($product->img_path);
        }
        $product->delete();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
	}

}
