<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
        if(!Schema::hasTable('myadmin_transactions')) {
            Schema::create('myadmin_transactions', function($table){
                $table->increments('id');
                $table->integer('user_id')->unsigned();
                $table->integer('response_id')->unsigned();
                $table->integer('price')->unsigned();
                $table->text('products');
                $table->text('readable_products');
                $table->timestamps();

                $table->string('payment_type', 20)->nullable();

                $table->integer('status');
                $table->string('comment', 255)->nullable();
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::drop('myadmin_transactions');
	}

}
