<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateResponseTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('myadmin_credit_responses')) {
            Schema::create('myadmin_credit_responses', function(Blueprint $table){
                $table->increments('id');
                $table->string('tradeID', 40)->nullable(); // because user maybe quit buying the merchandis suddenly, the tradeNo can be nullable
                $table->integer('tradeRef')->unsigned()->nullable(); 
                $table->integer('tradeNo')->nullable();
                $table->string('receiptNo')->nullable();
                $table->string('cardType')->nullable();
                $table->string('trade_status', 20)->nullable();
                $table->timestamp("payment_date");

                $table->unique('tradeRef');
                $table->foreign('tradeRef')->references('id')->on('transactions');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('myadmin_credit_responses');
    }

}
