@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
@stop

@section('content')
<style type="text/css" media="screen">
    img#preview{
        width:150px;
        height:150px;
        padding:2px;
        border:1px solid #000;
    }
</style>
<div>
    {{ Form::open(array(
        'action'=>$_CONST["CONTROLLER_ROUTE"].'.store',
        'class'=>'form-horizontal well',
        'files' => true
    ))}}
    <div class="form-group ">
        <label class="col-sm-2 control-label">標題</label>
        <div class="col-sm-10">
            {{ Form::text('title', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">副標題</label>
        <div class="col-sm-10">
            {{ Form::text('sub_title', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">分類</label>
        <div class="col-sm-10">
            {{ Form::select('category_id', $option, null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">價格</label>
        <div class="col-sm-10">
            {{ Form::text('price', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">圖片上傳</label>
        <div class="col-sm-10">
            {{ Form::file('image')}}
            <img style="width:150px;height:150px" id="preview" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">文章內容</label>
        <div class="col-sm-10">
            {{ Form::textarea('origin_content', null, array('class' => 'input-xxlarge form-control'))}}
        </div>
    </div>
    <hr>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <input type="submit" name="" value="編輯完成" class="btn btn-primary"  />
        </div>
    </div>
    {{ Form::close()}}
</div>
@stop

@section('js-snippet')
    @include('Myadmin::js.preview', array('bind' => 'input[name=image]','target' => '#preview'))
    @include('Myadmin::js.ckeditor', array(
        'target' => 'origin_content',
    ))
@stop
