@extends('Myadmin::layout.basic')

@section('content')
<div>
    <div class="input-prepend input-append">
    </div>
    <h4 class="nametag">{{{ trans("aio-payment::view.title")}}}</h4>
    <hr>
    <div class="panel panel-success">
        <div class="panel-heading" role="tab" id="headingOne">
            <h4 class="panel-title">
                <a data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                    <span class="glyphicon glyphicon-search"></span>
                    進階搜尋
                </a>
            </h4>
        </div>
        <div id="collapseOne" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
            <div class="panel-body">
                {{ Form::open(array("action"=>"MyadminAioController@index", "method"=>"get", "class"=>"form-horizontal")) }}
                <div class="form-group">
                    <label class="col-sm-2 control-label"><input name="use_keyword" type="checkbox">關鍵字：</label>
                    <div class="col-xs-4">
                        <input class="form-control" name="keyword" placeholder="">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label"><input name="use_date" type="checkbox">起迄時間：</label>
                    <div class="col-xs-4">
                        <input class="form-control" name="begin_date" id="begin-date" placeholder="">~
                        <input class="form-control" name="end_date" id="end-date" placeholder="">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label"><input name="use_status" type="checkbox">訂單狀態：</label>
                    <div class="col-xs-4">
                        <select name="status" class="form-control">
                            <option value="1">下單中</option>
                            <option value="2">付款完成</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                        <input type="submit" class="btn btn-primary" value="搜尋" >
                    </div>
                </div>
                {{ Form::close()}}
            </div>
        </div>
    </div>
    <table class="table table-bordered">
        <tr><th>訂單編號</th><th>顧客</th><th>金額</th><th>狀態</th><th>訂單成立時間</th><th>操作</th></tr>
        @foreach ($transactions as $transaction) 
        <tr>
            <td>{{{ $transaction->id}}}</td>
            <td>{{{ $transaction->consumer->name}}}</td>
            <td>{{{ $transaction->price}}}</td>
            <td>{{{Aio::getTransactionStatus($transaction->status)}}}</td>
            <td>{{{ $transaction->created_at}}}</td>
            <td>
                <a href="{{{ action("MyadminAioController@show", $transaction->id)}}}" class="btn btn-primary">
                    <span class="glyphicon glyphicon-eye-open"></span>
                    詳細資料
                </a>
            </td>
        </tr>
        @endforeach
    </table>
    <div class="pagination">
        {{ $transactions->appends(Input::except('page'))->links()}}
    </div>
</div>
<script>
$(function() {
    var format = "yy-mm-dd";
    $("#begin-date" ).datepicker({dateFormat: format});
    $("#end-date" ).datepicker({dateFormat: format});
});
</script>
@stop
