@extends('Myadmin::layout.basic')

@section('content')
<style type="text/css" media="screen">
    img#preview{
        width:150px;
        height:150px;
        padding:2px;
        border:1px solid #000;
    }
</style>
<h4 class="nametag">交易紀錄</h4>
<hr>
<div class="">
    <div class="panel panel-warning">
        <div class="panel-heading"><h2>買家資料</h2></div>
        <table class="table table-bordered table-hover">
            <tr><td>姓名</td><td>{{{$consumer->name}}}</td></tr>
            <tr><td>電話</td><td>{{{$consumer->phone}}}</td></tr>
            <tr><td>E-mail</td><td>{{{$consumer->email}}}</td></tr>
            <tr><td>住址</td><td>{{{$consumer->address}}}</td></tr>
        </table>
    </div>
    <div class="panel-success">
        <div class="panel-heading"><h2>購物清單</h2></div>
        <table class="table table-bordered table-hover">
            <tr><th>物品名稱</th><th>購買數量</th></tr>
            @foreach (json_decode($transaction->products) as $raw)
            @if ($product = MyadminProduct::findOrFail($raw->id))@endif
            <tr><td>{{{$product->title}}}</td><td>{{{$raw->amount}}}</td></tr>
            @endforeach
            <tr class="warning"><td colspan="2">總金額：{{{$transaction->price}}}</td></tr>
        </table>
    </div>
    <div class="panel-primary">
        <div class="panel-heading">
            <h2>
                交易狀況<span class="label label-danger">{{{Aio::getTransactionStatus($transaction->status)}}}</span>
            </h2>
        </div>
        <table class="table table-bordered table-hover">
            @if (($response = $transaction->response)!= null )
            <tr><td>交易號碼</td><td>{{{$response->tradeNo}}}</td></tr>
            <tr><td>訂單編號</td><td>{{{$transaction->id}}}</td></tr>
            <tr><td>下單日期</td><td>{{{$transaction->created_at}}}</td></tr>
            <tr><td>付款日期</td><td>{{{$response->payment_date}}}</td></tr>
            <tr><td>通路費</td><td>{{{$response->charge_fee}}}</td></tr>
            <tr><td>信卡卡前6碼</td><td>{{{$response->card6no}}}</td></tr>
            <tr><td>信卡卡後4碼</td><td>{{{$response->card4no}}}</td></tr>
            @endif
        </table>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">附註</div>
        <div class="panel-body">
            {{ nl2br($transaction->comment)}}
        </div>
    </div>

</div>
@stop
