<?php

class MyadminArticleController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';

    // self defined members
    protected $_CONST;
    protected $articleModelInstance;
    protected $articleClassModelInstance;


    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));
        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["CONTROLLER_ACTION"] = $routeAction;
        $this->_CONST["CLASS_CONTROLLER"] = $this->getClassController(); // interface function
        $this->_CONST["LANG_DEST"] = $this->getLangDest(); // interface function
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;

        $this->articleModelInstance = $this->getArticleInstance();
        $this->articleClassModelInstance = $this->getArticleClassInstance();
    
    }

    public function getLike($article_id, $blogger_id)
    {
	$object ='ARTICLE';
	$action ='LIKE';
	$chk_like = DB::table('action_log')
			->where('object',$object)
			->where('object_id',$article_id)
			->where('action',$action)
			->where('user_id',Session::get('userId'))->count();
	if($chk_like == 0)
	{
	        $comment = DB::table('action_log')->insert(array(
                                                'action' => $action,
                                                'object_id' => $article_id,
                                                'object' => $object,
                                                'blogger_id' => $blogger_id,
                                                'user_id' => Session::get('userId'),
						'created_at' => DB::raw('CURRENT_TIMESTAMP')));		
	}
	else{
		DB::table('action_log')
			->where('object',$object)
                        ->where('object_id',$article_id)
                        ->where('action',$action)
                        ->where('user_id',Session::get('userId'))->delete();
	}

        $like_num = DB::table('action_log')->where('object','ARTICLE')->where('object_id',$article_id)->where('action','LIKE')->count();
        $Alllike_num = DB::table('action_log')->where('object','ARTICLE')->where('blogger_id',$blogger_id)->where('action','LIKE')->count();

        //update the like_num to db
        DB::table('myadmin_articles')->where('id', $article_id)->update(array('likes'=>$like_num));
        DB::table('bloggers')->where('id', $blogger_id)->update(array('like_num'=>$Alllike_num));

	return Redirect::back();
    }

    public function getActions($article_id,$action,$blogger_id)
    {
		$object ="ARTICLE";
                $comment = DB::table('action_log')->insert(array(
                                                'action' => $action,
                                                'object_id' => $article_id,
                                                'object' => $object,
                                                'blogger_id' => $blogger_id,
                                                'user_id' => Session::get('userId'),
						'created_at' => DB::raw('CURRENT_TIMESTAMP')));
	return Redirect::back();
    }



    public function getComment($article_id)
    {
	$articles[0] = "請選擇";
	foreach ($this->articleModelInstance->all() as $article ) {
		$articles[$article->id] = $article->title;
	}
	if($article_id == 0)
	{
		$article_content = "N";
		$comments = "";
	}
	else
	{
		$article_content = $this->articleModelInstance->where('id','=',$article_id)->get();
		$comments = DB::table('article_comments')->where('article_id', '=', $article_id)->get(); 
	}
        return View::make('article-system::article.comment')
          ->with('_CONST', $this->_CONST)
	  ->withArticles($articles)
	  ->withArticleContent($article_content)
	  ->withComments($comments);	
    }
    
    public function getDeleteComment($id)
    {
	DB::table('article_comments')->where('id',$id)->delete();
	return Redirect::back();
    }

    public function postNewcomment()
    {
	$userInput = Input::all();
	if(Session::has('userId')) 
		$userId = Session::get('userId'); 
	else 
		$userId =  Session::get('id');
	if(Session::has('userName'))
		 $userName = Session::get('userName');
	else
		$userName =  Session::get('id');
        $comment = DB::table('article_comments')->insert(array(
						'blogger_id' => $userInput['blogger_id'],
        					'comment_content' => $userInput['comment_content'],
					        'commender_id' => $userId,
					        'commender' => $userName,
					        'article_id' => $userInput['article_id']));
	return Redirect::to(URL::previous() . '#finish_comment');//back();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $a = $this->getArticleInstance();
        $categories = array();
        $categories[0] = "總覽";
	$articles = null;
        foreach ($this->articleClassModelInstance->all() as $category ) {
	  if($category->is_available){
          	$categories[$category->id] = $category->title;
        	$article = $this->articleModelInstance->where('category','=',$category->id)->get();
		$articles = $articles.trim($article,"[]");
	  }
	  else{
		//$invisible_category = $this->articleModelInstance->where('category','=',$category->id)->update(array('isActive' => 0));
	  }
	
        }
	$blogger_table = DB::table('bloggers')->where('isActive','1')->get();
        $option_bloggers = array();
        foreach ($blogger_table as $blogger) {
            $option_bloggers[$blogger->id] = $blogger->name;
        }
	$articles = "[".$articles."]";
        return View::make('article-system::article.index')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withBlogger($option_bloggers)
            ->withCategories($categories)
            ->withArticles($this->articleModelInstance->all());
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $option = array();
        foreach ($this->articleClassModelInstance->all() as $category) {
            $option[$category->id] = $category->title;
        }
	$blogger_table = DB::table('bloggers')->where('isActive','1')->get();
        $option_bloggers = array();
        foreach ($blogger_table as $blogger) {
            $option_bloggers[$blogger->id] = $blogger->name;
        }
	$product_table = \Product::where('publish','1')->get();
        $option_products = array();
        foreach ($product_table as $product) {
            $option_products[$product->title] = $product->title;
        }
        if (Input::has("category")) {
            $default = Input::get("category");
        }else{
            $default = 1;
        }
        return View::make('article-system::article.create')
            ->with('_CONST', $this->_CONST)
            ->withOption($option)
            ->withOptionBloggers($option_bloggers)
            ->withOptionProducts($option_products)
            ->withDefault($default);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();
        $article = $this->articleModelInstance;
/*        $article->title = $userInput['title'];
        $article->category_id = $userInput['category_id'];
        $article->origin_content = $userInput['origin_content'];
        $article->content = strip_tags($userInput['origin_content']);
        $article->profolio_path = extract_first_img($userInput['origin_content']);
*/
	//$article->user_id = $userInput['user_id'];
	
	$blogger_table = DB::table('bloggers')->where('isActive','1')->get();
        $option_bloggers = array();
        foreach ($blogger_table as $blogger) {
            $option_bloggers[$blogger->id] = $blogger->name;
        }

	//check blogger info 
//	$article->blogger_id = $userInput['user_id'];        
//	$article->blogger_name = $option_bloggers['$userInput['user_id']'];        
	$blogger_chk = DB::table('bloggers')->where('id','=',$userInput['blogger_id'])->count();
	if($blogger_chk > 0)
	{	        
		$blogger = DB::table('bloggers')->where('id','=',$userInput['blogger_id'])->first();	        
		$article->blogger_id = $blogger->id;        
		$article->blogger_name = $blogger->name;
		$article->blogger_img = $blogger->photo;        
	}

	$article->category = $userInput['category_id'];        
	$article->created_at = date("Y-m-d",strtotime($userInput['created_at']));

	if(Input::has('tag_1'))
		$article->tag1 = $userInput['tag_1'];        
	if(Input::has('tag_2'))
		$article->tag2 = $userInput['tag_2'];        
	if(Input::has('tag_3'))
		$article->tag3 = $userInput['tag_3'];        
	if(Input::has('mention_product'))
		$article->mention_product = $userInput['mention_product'];        
	if(Input::has('youtube_url'))
		$article->youtube_url = $userInput['youtube_url'];        

	$article->title = $userInput['title'];        
	$article->description = $userInput['description'];        
	$article->likes = 0;
	$article->isActive = $userInput['publish'];        
            if(Input::hasFile('image'))
            {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $article->img_path =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
            }
	if(Input::hasFile('mention_img'))
	{	
                $dest = img_upload_path();
                $file = Input::file('mention_img');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $article->mention_img =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
        }	
	if(Input::has('mention_store'))
		$article->mention_store = $userInput['mention_store'];        
	if(Input::has('mention_phone'))
		$article->mention_phone = $userInput['mention_phone'];        
	if(Input::has('mention_address'))
		$article->mention_address = $userInput['mention_address'];        
	if(Input::has('mention_content'))
		$article->mention_content = $userInput['mention_content'];        
	$article->save();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $a = $this->getArticleInstance();
        $categories[0] = "總覽";
        foreach ($this->articleClassModelInstance->all() as $category ) {
	  if($category->is_available)
            $categories[$category->id] = $category->title;
        }
        $articles = $this->articleModelInstance->where('category','=',$id)->get();
        return View::make('article-system::article.show')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withCid($id)
            ->withCategories($categories)
            //->withArticles($this->articleClassModelInstance->findOrFail($id)->articles);
            ->withArticles($articles);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $article = $this->articleModelInstance->findOrFail($id);
        foreach ($this->articleClassModelInstance->all() as $category) {
            $option[$category->id] = $category->title;
        }
	$blogger_table = DB::table('bloggers')->where('isActive','1')->get();
        $option_bloggers = array();
        foreach ($blogger_table as $blogger) {
            $option_bloggers[$blogger->id] = $blogger->name;
        }
	$product_table = \Product::where('publish','1')->get();
        $option_products = array();
        foreach ($product_table as $product) {
            $option_products[$product->title] = $product->title;
        }
        return View::make('article-system::article.edit')
            ->with('_CONST', $this->_CONST)
            ->withOption($option)
            ->withOptionBloggers($option_bloggers)
            ->withOptionProducts($option_products)
	    ->withArticle($article);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $userInput = Input::all();
        $article = $this->articleModelInstance->findOrFail($id);

	$blogger_table = DB::table('bloggers')->where('isActive','1')->get();
        $option_bloggers = array();
        foreach ($blogger_table as $blogger) {
            $option_bloggers[$blogger->id] = $blogger->name;
        }

	//check blogger info 
	//$article->blogger_id = $userInput['user_id'];        
	//$article->blogger_name = $option_bloggers[$userInput['user_id'];        

	$blogger_chk = DB::table('bloggers')->where('id','=',$userInput['blogger_id'])->count();
	if($blogger_chk > 0)
	{	        
		$blogger = DB::table('bloggers')->where('id','=',$userInput['blogger_id'])->first();	        
		$article->blogger_id = $blogger->id;        
		$article->blogger_name = $blogger->name;        
		$article->blogger_img = $blogger->photo;        
	}

        $article->category = $userInput['category'];
	$article->created_at = date("Y-m-d",strtotime($userInput['created_at']));

        if(Input::has('tag1'))
                $article->tag1 = $userInput['tag1'];
        if(Input::has('tag2'))
                $article->tag2 = $userInput['tag2'];
        if(Input::has('tag3'))
                $article->tag3 = $userInput['tag3'];
        if(Input::has('has_product'))
                $article->mention_product = $userInput['mention_product'];
        if(Input::has('youtube_url'))
                $article->youtube_url = $userInput['youtube_url'];

        $article->title = $userInput['title'];
        $article->description = $userInput['description'];

	if(Input::has('mention_product'))
		$article->mention_product = $userInput['mention_product'];        
        $article->created_at = $userInput['created_at'];
	if(Input::has('publish'))
	        $article->isActive = $userInput['publish'];
            if(Input::hasFile('image'))
            {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $article->img_path =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
            }
        if(Input::hasFile('mention_img'))
        {
                $dest = img_upload_path();
                $file = Input::file('mention_img');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $article->mention_img =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
        }
        if(Input::has('mention_store'))
                $article->mention_store = $userInput['mention_store'];
        if(Input::has('mention_phone'))
                $article->mention_phone = $userInput['mention_phone'];
        if(Input::has('mention_address'))
                $article->mention_address = $userInput['mention_address'];
        if(Input::has('mention_content'))
                $article->mention_content = $userInput['mention_content'];
        $article->save();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
	DB::table('action_log')->where('object','ARTICLE')->where('object_id',$id)->delete();
        $article = $this->articleModelInstance->findOrFail($id);
        $article->delete();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }

    public function getLangDest()
    {
        return "article-system::view";
    }

    /*
    public function getClassController()
    {
        // rewrite classes controller by extended controller...
    }

    private function getArticleInstance()
    {
        // return an instance of model
    }
    */

    public function getEnable($id)
    {
        
      	  $article = $this->articleModelInstance->findOrFail($id);
	  $article->isActive = True;
	  $article->save();
        $id = \Session::get('id');
        OperatorLog::saveItem($id, "顯示文章 " . $article['title']);
        return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
         
    }

    public function getDisable($id)
    {
          $article = $this->articleModelInstance->findOrFail($id);
          $article->isActive = False;
          $article->save();
	$id = \Session::get('id');
        OperatorLog::saveItem($id, "隱藏文章 " . $article['title']);
        return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
    }
}
