<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AdminArticleTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
        $self_table_name = "myadmin_articles";
        if(!Schema::hasTable($self_table_name)) {
            Schema::create($self_table_name, function(Blueprint $table){
                $partent_table_name = "myadmin_article_classes";
                $table->increments('id');
                $table->integer('user_id');
                $table->string('title', 250);
                $table->string('category', 250);
                $table->string('tag1', 250);
                $table->string('tag2', 250);
                $table->string('tag3', 250);
                $table->string('mention_product', 250);
                $table->string('blogger_id', 250);
                $table->string('blogger_name', 250);
                $table->string('blogger_img', 250);
                $table->string('img_path', 250);
                $table->string('youtube_url', 250);
                $table->string('description', 500);
                $table->string('mention_img', 250);
                $table->string('mention_store', 250);
                $table->string('mention_phone', 250);
                $table->string('mention_address', 250);
                $table->string('mention_content', 250);
                $table->boolean('isActive')->default(True);
                $table->integer('likes');
                $table->timestamps();
            });
        }

        $self_table_name = "article_comments";

        if(!Schema::hasTable($self_table_name)) {
            Schema::create($self_table_name, function(Blueprint $table){
                $table->increments('id');
                $table->integer('article_id');
                $table->string('blogger_id');
                $table->string('comment_content', 250);
                $table->string('commender_id', 250);
                $table->string('commender', 250);
                $table->timestamps();
            });
        }
        //Schema::table($this->self_table_name, function($table){
        //});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		DB::statement('SET FOREIGN_KEY_CHECKS = 1');
        $self_table_name = "myadmin_articles";
        Schema::dropIfExists($self_table_name);
		DB::statement('SET FOREIGN_KEY_CHECKS = 0');
	}

}
