@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
@stop

@section('content')
<div class="span10 offset1">
    {{ Form::model($article, array(
        'route' => array($_CONST["CONTROLLER_ROUTE"].'.update', $article->id),'files'=>true,
        'class' =>'form-horizontal well',
        'method' => 'put'
    ))}}
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <input type="submit" name="" value="編輯完成" class="btn btn-primary"  />
	    <a href="{{ action($_CONST["CONTROLLER_ROUTE"].'.index')}}" class="btn btn-default">回上頁 </a>
        </div> <!--CLASS_CONTROLLER-->
    </div>

    <div class="form-group ">
        <label class="col-sm-2 control-label">發佈</label>
        <div class="col-sm-10">
                @if($article->isActive)
                   <div class="col-sm-1">    {{ Form::radio('publish', '1', true )}}是 </div>
                   <div class="col-sm-1">    {{ Form::radio('publish', '0')}}否 </div>
                @else
                   <div class="col-sm-1">    {{ Form::radio('publish', '1')}}是 </div>
                   <div class="col-sm-1">    {{ Form::radio('publish', '0', true)}}否 </div>
                @endif
        </div>
    </div>
    <div class="form-group ">
                <label class="col-sm-2 control-label">分類</label>
                <div class="col-sm-10">
                        {{ Form::select('category', $option, null, array('class' => 'form-control'))}}
                </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">部落客姓名</label>
        <div class="col-sm-10">
{{--            {{ Form::text('blogger_name', null, array('placeholder'=> '輸入名稱','id'=>'auto','class'=>'form-control'));}}--}}
                        {{ Form::select('blogger_id', $option_bloggers, null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group" id="close">
        <label class="col-sm-2 control-label">
                <span class="glyphicon glyphicon-calendar add-on btn" data-date-icon="icon-calendar"></span>
                日期
        </label>
        <div class="col-sm-5">
                 <!--input type="date" name="created_at" class="form-control" value="{{$article->created_at}}"/-->
		{{ Form::input('date','created_at',date("Y-m-d",strtotime($article->created_at)), array('class'=>'form-control')) }}
        </div>
        <div class="col-sm-5">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">封面照</label>
        <div class="col-sm-2">
                        <input name="image" type="file" onchange="loadFile(event)">
           {{ HTML::image($article->img_path,"",['style'=>'width:150px;height:150px', 'id'=>'img_show']) }}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">tag1(optional)</label>
        <div class="col-sm-2">
            {{ Form::text('tag1', null, array('class' => 'form-control'))}}
        </div>
        <label class="col-sm-2 control-label">tag2(optional)</label>
        <div class="col-sm-2">
            {{ Form::text('tag2', null, array('class' => 'form-control'))}}
        </div>
        <label class="col-sm-2 control-label">tag3(optional)</label>
        <div class="col-sm-2">
            {{ Form::text('tag3', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">影片連結</label>
        <div class="col-sm-10">
            {{ Form::text('youtube_url', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <hr>
    <div class="form-group ">
        <label class="col-sm-2 control-label">標題</label>
        <div class="col-sm-10">
            {{ Form::text('title', null, array('class'=>'form-control'));}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">文章內容</label>
        <div class="col-sm-10">
            {{ Form::textarea('description', null, array('class' => 'input-xxlarge form-control ckeditor'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">提及商品</label>
        <div class="col-sm-10">
{{--            {{ Form::text('mention_product', null, array('placeholder'=> '商品','id'=>'auto_product','class'=>'form-control'));}}--}}
                        {{ Form::select('mention_product', $option_products, null, array('class' => 'form-control'))}}
        </div>
    </div>
    <hr>
    <div class="form-group ">
        <label class="col-sm-2 control-label">提及地點</label>
        <label class="col-sm-2 text-left">圖片</label>
        <label class="col-sm-2 text-left">店名</label>
        <label class="col-sm-2 text-left">電話</label>
        <label class="col-sm-2 text-left">地址</label>
        <label class="col-sm-2 text-left">內容</label>
    </div>
    <div class="form-group ">
        <div class="col-sm-2">
        </div>
        <div class="col-sm-2">
    	       <input name="mention_img" type="file" onchange="loadFileMention(event)">
           {{ HTML::image($article->mention_img,"",['style'=>'width:150px;height:150px', 'id'=>'mention_img_show']) }}
        </div>
        <div class="col-sm-2">
            {{ Form::text('mention_store', null, array('placeholder'=> '店名','id'=>'auto_store','class'=>'form-control'));}}
        </div>
        <div class="col-sm-2">
            {{ Form::text('mention_phone', null, array('placeholder'=> '電話','class'=>'form-control'));}}
        </div>
        <div class="col-sm-2">
            {{ Form::textarea('mention_address', null, array('placeholder'=> '地址','class'=>'form-control'));}}
        </div>
        <div class="col-sm-2">
            {{ Form::textarea('mention_content', null, array('placeholder'=> '提及內容','class'=>'form-control'));}}
        </div>
    </div>
    {{ Form::close()}}
    <script type="text/javascript" charset="utf-8">
        $(document).ready(function () {
         $('input:text').bind({

         });
         // Write on keyup event of keyword input element
         $("#auto").on("keyup change mousedown keydown", function(){
              // When value of the input is not blank
             var term,url = '{{URL('getblogger/')}}';
             term = $(this).val();
             var url_item = url +"/"+ term;
             console.log(url_item);
             $("#auto").autocomplete({
                  minLength:1,
                  autofocus: true,
                  source: url_item
              });
            });
         // Write on keyup event of keyword input element
         $("#auto_product").on("keyup change mousedown keydown", function(){
              // When value of the input is not blank
             var term,url = '{{URL('getproducts/')}}';
             term = $(this).val();
             var url_item = url +"/"+ term;
             console.log(url_item);
             $("#auto_product").autocomplete({
                  minLength:1,
                  autofocus: true,
                  source: url_item
              });
            });
         });


  var loadFile = function(event) {
    var reader = new FileReader();
    reader.onload = function(){
      var output = document.getElementById('img_show');
      output.src = reader.result;
    };
    reader.readAsDataURL(event.target.files[0]);
  };

  var loadFileMention = function(event) {
    var reader = new FileReader();
    reader.onload = function(){
      var output = document.getElementById('mention_img_show');
      output.src = reader.result;
    };
    reader.readAsDataURL(event.target.files[0]);
  };

/*        @include('Myadmin::js.ckeditor', array(
            'target' => 'description',
        ))
*/
    </script>
</div>
@stop
