@extends('Myadmin::layout.basic')

@section('content')
<div class="row-fluid">
    <div class="span9">
        <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".title")}}}</h4>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create', "category=".$cid)}}" class="btn btn-primary">
            <span class="glyphicon glyphicon-file"></span>
            {{{ trans($_CONST["LANG_DEST"].".create_action")}}}
        </a>
        <a href="{{ action($_CONST["CLASS_CONTROLLER"].'@index')}}" class="btn btn-success">
            <span class="glyphicon glyphicon-th-list"></span>
            {{{ trans($_CONST["LANG_DEST"].".browse_class")}}}
        </a>
        <hr>
        {{ Form::open(array(  'class'=>'form-horizontal well'))}}
        <div class="input-group">
            <span class="input-group-addon">{{{ trans($_CONST["LANG_DEST"].".select_class")}}}：</span>
            {{ Form::select('id', $categories, $cid, array('class' => 'form-control') )}}
        </div>
        {{ Form::close()}}
        <table class="table table-bordered">
            <tr>
                <th>發文日期</th>
                <th>文章標題</th>
                <th>部落客姓名</th>
                <th>發文帳號</th>
                <th>編輯日期</th>
                <th>發佈</th>
            </tr>
            @if(isset($articles))
            @foreach ($articles as $article)
            <tr>
                <td>{{{ $article->created_at}}}</td>
                <td>{{{ $article->title}}}</td>
                <td>
                    {{{ $article->blogger_name}}}
                </td>
                <td>{{{ $article->id}}}</td>
                <td>
                        <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@edit', $article->id)}}" class="btn btn-info" ><i class="icon-ok-circle"></i>編輯</a>
                        {{{ $article->updated_at}}}</td>
                <td>
                    @if($article->isActive)
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getDisable', $article->id)}}" class="btn btn-success" ><i class="icon-ok-circle"></i>發佈中</a>
                    @else
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getEnable', $article->id)}}" class="btn btn-danger"><i class="icon-ban-circle"></i>停用中</a>
                    @endif
                </td>
            </tr>
            @endforeach
            @endif
        </table>
    </div>
<script type="text/javascript" charset="utf-8">
    $(document).change(function(){
        var t = $("select[name=id]").val();
        var base_url = "{{ route($_CONST["CONTROLLER_ROUTE"].".index")}}";
        if (t == 0) {
            var target = base_url;
        }else {
            var target = base_url + '/' + t;
        }
        window.location = target;
    });
</script>
</div>
@stop
