@extends('Myadmin::layout.basic')

@section('content')
<style>
    .check-item {
        height:15px;
    }
</style>

<div class="row-fluid">
    <div class="span9">
        <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".class_title")}}}</h4>
{{--
        <a href="{{{ action($_CONST['SUB_CONTROLLER'].'@index')}}}" class="btn btn-success">
            <span class="glyphicon glyphicon-arrow-left"></span>
            {{{ trans($_CONST["LANG_DEST"].".turn_back")}}}
        </a>
--}}
		<a href="{{URL::to('admin/productclass')}}" class="btn btn-link btn-custom" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			產品管理
		</a>
		<a href="{{URL::to('admin/articleclass')}}" class="btn btn-success btn-custom" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			文章管理
		</a>
		<a href="{{URL::to('admin/userclass')}}" class="btn btn-link btn-custom" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			部落客管理
		</a>
        <hr>
        {{ Form::open(array( 'action'=>$_CONST["CONTROLLER_ROUTE"].'.store', 'class'=>'form-horizontal well'))}}
        <div class="input-group">
            <span class="input-group-addon">{{{ trans($_CONST["LANG_DEST"].".new_class_name")}}}：</span>
            {{ Form::text('title', null, array('class' => 'form-control'))}}
            <span class="input-group-btn">
                <input type="submit" href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary" value="{{{ trans($_CONST["LANG_DEST"].".class_create_action")}}}">
            </span>
        </div>
        {{ Form::close()}}
        <table class="table table-bordered">
            <tr>
                <th>分類名稱</th>
                <th class="col-md-4">操作</th>
                <th>刪除</th>
                <th>呈現</th>
            </tr>
            @foreach ($categories as $category)
                <tr>
                <td><a href="{{ action($_CONST["SUB_CONTROLLER"].'@'.'show', $category->id)}}">{{{ $category->title}}}</a></td>
                <td>
{{ Form::model($category, array(
    'route' => array($_CONST["CONTROLLER_ROUTE"].'.update', $category->id),
    'class' =>'form-horizontal',
    'method' => 'put'
))}}
        <div class="input-group">
            {{ Form::text('title', '', array('class' => 'form-control'))}}
            <span class="input-group-btn">
                <input type="submit" href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary" value="{{{ trans($_CONST["LANG_DEST"].".class_rename_action")}}}">
            </span>
        </div>
{{ Form::close()}}
</td>
                <td>
                    {{ Form::open(array(
                        'route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $category->id),
                        'method' => 'delete')
                    )}}
                    {{ Form::submit(trans($_CONST["LANG_DEST"].".class_delete_action"), array("class"=>"delete  btn btn-large btn-danger"));}}
                    {{ Form::close()}}
                </td>
		<td>
			@if($category->is_available)
				<input type="checkbox" name ="visible" checked class="form-control check-item" onchange="isVisiable(1,{{$category->id}})"/>
			@else
				<input name ="visible" type = "checkbox"  class="form-control check-item" onClick='isVisiable(0,{{$category->id}})'/>
			@endif
		</td>
                </tr>
            @endforeach
        </table>
    </div>
</div>
<script type="text/javascript" charset="utf-8">
    function isVisiable(is, id){
	var base_url = "{{URL::to('admin/articleclass/')}}";
        if (is == 0) {
            var target = base_url + '/' + "enable" + '/' + id;
        }else {
            var target = base_url + '/' + "disable" + '/' + id;
        }
        window.location = target;
    }
</script>


@stop
