<?php

class MyadminConsumerController extends \BaseController {

    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));
        
        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["CONTROLLER_ACTION"] = $routeAction;
    
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        return View::make('consumer-management::index')
            ->with('_CONST', $this->_CONST)
            ->withUsers(MyadminConsumer::paginate(15));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $this->layout->content = View::make('user-management::user.create')
            ->with('_CONST', $this->_CONST);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();
        $validator = Validator::make(
            $userInput,
            array(
                'account' => 'required|unique:myadmin_users,account',

            )
        );
        if ($validator->fails()) {
            Input::flashExcept('password');
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.create')->withErrors($validator->messages());
        }else{
            $user = MyadminUser::firstOrCreate(array('account' => $userInput['account']));
            $user->account = $userInput["account"];
            $user->password = Hash::make($userInput["password"]);
            $user->name = $userInput["name"];
            $user->email = $userInput["email"];
            $user->phone = $userInput["phone"];
            $user->permission = $userInput["permission"];
            $user->isActive = 1;
            $user->save();
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $user = MyadminUser::findOrFail($id);
        $this->layout->content = View::make('user-management::user.edit')
            ->with('_CONST', $this->_CONST)
            ->withUser($user);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $validator = $this->userValidator(Input::all());
        if ($validator->fails()) {
            Input::flashExcept('password');
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.edit', $id)->withErrors($validator->messages());
        }else{
            $userInput = Input::all();
            $user = MyadminUser::findOrFail($id);
            $user->account = $userInput["account"];
            $user->name = $userInput["name"];
            $user->email = $userInput["email"];
            $user->phone = $userInput["phone"];
            $user->permission = $userInput["permission"];
            $user->isActive = 1;
            $user->save();
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
    }

    public function destroy($id)
    {
        $user = MyadminUser::findOrFail($id);
        $user->delete();
        return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
    }

}
