<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateConsumerTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
    {
        if(!Schema::hasTable('myadmin_consumers')) {
            Schema::create('myadmin_consumers', function($table){
                $table->increments('id');
                $table->string('account', 20);
                $table->string('password', 60);
                $table->string('name', 50)->nullable();
                $table->string('email', 100)->nullable();
                $table->string('phone', 20)->nullable();
                $table->string('address', 100)->nullable();
                $table->timestamps('');
                $table->softDeletes();
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::drop('myadmin_consumers');
	}

}
