<?php 

/************************************
 *
 * image upload basic config and helper functions
 *
 */
function img_upload_path()
{
    return public_path() . '/imgs/';
}

function img_upload_path_prefix()
{
    return '/imgs/';
}

function img_upload_url($url)
{
    return asset($url);
}

function img_test_and_remove($path)
{
    $path = realpath(public_path().$path);
    if ($path) {
        unlink($path);
        return true;
    }else {
        return false;
    }
}


/**************************************
 *
 * file upload config and path
 *
 *************************************/
function file_upload_path()
{
    return public_path() . '/files/';
}

function file_upload_suffix()
{
    return '/files/';
}

/*
 * extract the <img> tag of attribute src"..."
 * @param string 
 */
function extract_first_img($content)
{
    $pattern = '/<img[^>]*src="([^"]*)"/';
    preg_match($pattern, $content, $matches, PREG_OFFSET_CAPTURE);
    return isset($matches[1][0])? $matches[1][0]: null;
}

/*
 * cut multi byte function
 * @param string content
 * @param int length
 */
function mb_cut($content, $length)
{
    if (mb_strlen($content) > $length) {
        return mb_substr($content, 0, $length).'...';
    }else {
        return $content;
    }
}
