<!DOCTYPE HTML>
<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8">
        <!--[if lte IE 8]>
        <script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
        <![endif]-->
        <title>{{ trans("Myadmin::layout.title")}} - 後台管理</title>
        <link rel="stylesheet" href="{{ App::make("myadmin")->asset('/bootstrap/css/bootstrap.min.css') }}" type="text/css" media="screen" charset="utf-8"> 
        <link rel="stylesheet" type="text/css" title="Style" href="{{ App::make("myadmin")->asset('jquery-ui/jquery-ui.css') }}"/>
        <link rel="stylesheet" type="text/css" title="Style" href="{{ App::make("myadmin")->asset('css/basic.css') }}"/>
        <script src="{{ App::make("myadmin")->asset('js/jquery.min.js') }}" type="text/javascript" charset="utf-8">
        </script>
        <script src="{{ App::make("myadmin")->asset('js/common-method.js') }}" type="text/javascript" charset="utf-8">
        </script>
        <script src="{{ App::make("myadmin")->asset('/jquery-ui/jquery-ui.js') }}"></script>
        </script>
        <script src="{{ App::make("myadmin")->asset('/bootstrap/js/bootstrap.min.js') }}" type="text/javascript" charset="utf-8">
        </script>
        <script type="text/javascript" charset="utf-8">
            $(document).ready(function(){
                $("form .delete").click(function(){
                    return confirm("{{ trans('Myadmin::layout.whether_to_delete')}}");
                });

                setInterval(function(){ 
                   scheduleLog(); 
                }, 10000);
                $( window ).resize(function() {
                    $("#header").css("width", $("#main-body").width());
                });
                $("#header").css("width", $("#main-body").width());
            });

            function scheduleLog() {
                $.get("{{ URL::to('admin/operators-log') }}", { "time": $("#log-H #pTime").attr("time")}, function( data ) {
                    var obj = JSON.parse(data);

                    for(var i = 0; i < obj.length; i++) {
                        $("#log-H #pTime").attr("time", obj[i].updated_at);
                        $("#log-H table tbody").prepend(
                            $("<tr/>").append(
                                $("<td/>").html(obj[i].username),
                                $("<td/>").html(obj[i].operator),
                                $("<td/>").html(obj[i].updated_at)
                            )
                        );
                    }
                });
            };
        </script>
        @section('header')
        @show
        <style type="text/css" media="screen">
        </style>

    </head>
    <body>
        <nav id="header" class="navbar" role="navigation">
        <div class="row">
            <div class="col-xs-1 col-sm-1">
            </div>
            <div class="col-xs-8 col-sm-8">
                @section('show-menu-D')
                    <div></div>
                @show
            </div>
            <div class="block-F col-xs-3 col-sm-3">
                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="logout">
                    <a href={{ URL::to('admin/user/logout')}} class="btn btn-warning">Logout</a>
                </div>
            </div><!-- /.container-fluid -->
        </div><!-- /.row -->
        </nav>

    <div id="main-body" class="row">
        <div class="col-xs-1 col-sm-1" id="menu-list">
            {{--*/ $level = "" /*--}}
            @if(isset($_CONST["level"]))
                {{--*/ $level = $_CONST["level"] /*--}}
            @endif
            @if(isset($level))
                {{ $level }}
                <ul id="monitor-list" class="nav nav-pills nav-stacked">
                    @if($level == "最高管理員") 
                    @endif
                </ul>
                <hr>
                <ul id="analysis-list" class="nav nav-pills nav-stacked">
                    @if($level == "最高管理員") 
                    @elseif($level == "退換貨人員") 
                        <li><a>統計</a></li>
                        <li><a>歷史</a></li>
                        <li><a>LOG</a></li>
                    @endif
                </ul>
                <hr>
                <ul id="data-list" class="nav nav-pills nav-stacked">
                    @if($level == "最高管理員") 
                        <li><a href="{{ URL::to('admin/article') }}">文章資料</a></li>
                        <li><a href="{{ action("ProductController@index")}}">商品資料</a></li>
                        <li><a href="{{ URL::to('admin/user/manage') }}">會員資料</a></li>
                        <li><a href="{{ URL::to('admin/user/manager') }}">帳號資料</a></li>
                        <li><a href="{{ URL::to('admin/blogger') }}">部落客管理</a></li>
                     {{-- <li><a href="{{ URL::to('admin/bonus') }}">紅利資料</a></li> --}}
                        <li><a href="{{ URL::to('admin/productclass') }}">分類管理</a></li>
                        <li><a href="{{ URL::to('admin/product/shop/1') }}">實體店管理</a></li>
                        <li><a href="{{ URL::to('admin/product/order/1') }}">訂單管理</a></li>
                        <li><a href="{{ URL::to('admin/product/brands/1') }}">品牌管理</a></li>
                        <li><a href="{{ URL::to('admin/migs') }}">下訂單測試</a></li>
                     {{--   <li><a href="{{ URL::to('admin/article/comment/0') }}">留言測試</a></li>--}}
                        <li><a href="{{ URL::to('admin/delivery') }}">頁面管理</a></li>
                        <li><a href="{{ URL::to('admin/home') }}">首頁管理</a></li>
                        <li><a href="{{ URL::to('admin/home/reports/1') }}">報表分析</a></li>
                    @elseif($level == "客服人員") 
                        <li><a href="{{ action("ProductController@index")}}">商品資料</a></li>
                        <li><a href="{{ URL::to('admin/user/manage') }}">會員資料</a></li>
                        <li><a href="{{ URL::to('admin/article') }}">文章資料</a></li>
                    @elseif($level == "退換貨人員") 
                        <li><a href="{{ action("ProductController@index")}}">商品資料</a></li>
                    @endif
                </ul>
            @endif
        </div>
        <div id="content" class="col-xs-9 col-sm-9">
            @section('content')
            @show
            <div class="modal fade bs-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
              <div class="modal-dialog modal-sm">
                <div class="modal-content">
            @section('dialog')
                1232131
            @show
                </div>
              </div>
            </div>
        </div>
        <div class="col-xs-2 col-sm-2" id="log-H">
            @section('log-H')
                @if(isset($_CONST["operators"]))
                    {{--*/ $operators = $_CONST["operators"] /*--}}
                    {{--*/ $first = 0 /*--}}
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>操作者</th>
                                <th>操作</th>
                                <th>操作日期</th>
                            </tr>
                        </thead>
                        @foreach($operators as $operator)
                            @if($first == 0)
                                <div id="pTime" class="hidden" time="{{ $operator->created_at }}"></div>
                                {{--*/ $first++ /*--}}
                            @endif
                            <tr>
                                <td>{{ $operator->username }}</td>
                                <td>{{ $operator->operator }}</td>
                                <td>{{ $operator->created_at }}</td>
                            </tr>
                        @endforeach
                    </table>
                    {{ $_CONST["operators"]->links() }}
                @endif
            @show
        </div>
    </div>
    <footer>
        <hr>
        <div class="container">
            <a href="#">Architech design © 2014</a>
        </div>
    </footer>
    <script type="text/javascript" charset="utf-8">
        $(document).ready(function(){
            @section('js-snippet')
            @show
        });
    </script>
    </body>
</html>

