<?php

class MyadminProductClassController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';

    // self defined members
    protected $_CONST;
    protected $articleModelInstance;
    protected $articleClassModelInstance;


    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $level = \Session::get('level');
        $operators = OperatorLog::getLogList();

        $this->_CONST = array();
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["SUB_CONTROLLER"] = $this->getSubController();
        $this->_CONST["LANG_DEST"] = $this->getLangDest(); // interface function
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;

        $this->articleModelInstance = $this->getArticleInstance();
        $this->articleClassModelInstance = $this->getArticleClassInstance();
    }
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        return View::make('product-management::class.index')
            ->with('_CONST', $this->_CONST)
            ->withCategories($this->articleClassModelInstance->all())
            ->withArticles($this->articleModelInstance->all());
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
		echo "create test";
    }


    /**
     * Store a newly created categories in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();
        $class = $this->articleClassModelInstance; //->create(array('name' => $userInput['title']));
	$class->name = $userInput['title'];
        $class->save();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $category = $this->articleModelInstance;//->findOrFail($id);
        $articles = $category->articles;
        $this->layout->content = View::make('product-management::class.show')
            ->with('_CONST', $this->_CONST)
            ->withCurrent($category)
            ->withCategories($this->articleClassModelInstance->all())
            ->withArticles($articles);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $userInput = Input::all();
        $class = $this->articleClassModelInstance->findOrFail($id);
        $class->name = $userInput["title"];
        $class->save();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $product = $this->articleClassModelInstance->findOrFail($id);
        $product->delete();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }

    public function getFix($json){
        $objs = json_decode($json, true);

//		return $objs;
        foreach ($objs as $obj){
            $product = $this->articleClassModelInstance->findOrFail($obj['id']);
			if($obj['checked'] == true)
				$product->show = '1';
			else
				$product->show = '0';
/*
            $product->available_amount = $obj['available_amount'];
            $product->stock_amount = $obj['stock_amount'];
            $product->special_case = $obj['special_case'];
            $product->is_available = $obj['is_available'];
*/
            $product->save();
        }
        return Redirect::route('admin.productclass.index');
    }

	public function getTest()
	{
		echo "test route!!!";
	}

    public function getSubController()
    {
        // rewrite by subcontroller's name
    }

    public function getLangDest()
    {
        return "product-management::view";
    }

}
