<?php

class MyadminProductController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';

    // self defined members
    protected $_CONST;
    protected $articleModelInstance;
    protected $articleClassModelInstance;


    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));
        $level = \Session::get('level');
        $operators = OperatorLog::getLogList();


        $this->_CONST = array();
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["API_KEY"] = "AIzaSyA7WTKowixPBJ_y7LO71YRUrd0s3D6u15g";
        $this->_CONST["CONTROLLER_ACTION"] = $routeAction;
        $this->_CONST["CLASS_CONTROLLER"] = $this->getClassController(); // interface function
        $this->_CONST["LANG_DEST"] = $this->getLangDest(); // interface function
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;

        $this->selfModelInstance = $this->getSelfInstance();
        $this->classModelInstance = $this->getClassInstance();
        $this->bonusCatModelInstance = $this->getBonusCatInstance();
        $this->detailModelInstance = $this->getDetailInstance();   
        
    }
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $categories = array();
        $notification = array();
        $bonusoption = array();
		$firstid = -1;

        foreach ($this->classModelInstance->all() as $category) {
			if($firstid == -1 && $category->show == 1)
				$firstid = $category->id;
            $categories[$category->id] = $category->name;	//title -> name
        }

		return Redirect::to('admin/product/'.$firstid);
    }

    /* create new category */
    public function newclass()
    {
        $categories = array();
        $categories[0] = "總覽";
        foreach ($this->classModelInstance->all() as $category) {
            $categories[$category->id] = $category->name;	//title -> name
        }
        return View::make('product-management::product.newclass')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withCategories($categories)
            ->withProducts($this->selfModelInstance->paginate(15));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        if(isset($_GET['id'])) {
            $type = $_GET['id'];
        }
        else
            $type = 0;

        $bonusoption = array();
        $option = array();
		$region = array();
		$shop_name = array();

		$region[0] = "全選";
		$shop_name[0] = "全選";
		foreach (\Shops::all() as $shop){
			$region[$shop->id] = $shop->region;
			$shop_name[$shop->id] = $shop->name;
		}
		$region = array_unique($region);
		$shop_name = array_unique($shop_name);

        foreach ($this->bonusCatModelInstance->all() as $bonus) {
            $bonusoption[$bonus->id] = $bonus->category;
        }
        foreach ($this->classModelInstance->all() as $product) {
            if($product->show == 1)
                $option[$product->id] = $product->name;	//tile -> name
        }
		foreach (\Brands::all() as $br){
			$brand[$br->id] = $br->name;
		}
        return View::make('product-management::product.create')
            ->with('_CONST', $this->_CONST)
            ->withBonusoption($bonusoption)
            ->withCategorytype($type)
			->withRegion($region)
			->withShopname($shop_name)
			->withAddress(\Shops::all())
			->withBrands($brand)
            ->withOption($option);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();

//		$imgnum =  count($_FILES['image']['name']);
        $validator = Validator::make(
            $userInput,
            array(
                'title' => 'required',
                'price' => 'required|alpha_num'
            )
        );

        if ($validator->passes()) {
            $product = $this->selfModelInstance;

	        $product->category_id = $userInput['category_id'];
			$product->publish = $userInput['publish'];
            $product->title = $userInput['title'];
            $product->subheading = $userInput['subheading'];
            $product->format = $userInput['format'];
            $product->tag_1 = $userInput['tag_1'];
            $product->tag_2 = $userInput['tag_2'];
            $product->tag_3 = $userInput['tag_3'];
            $product->price = $userInput['price'];
            $product->selling_price = $userInput['selling_price'];
            $product->official_url = $userInput['official_url'];
            $product->start_date = $userInput['start_date'];
            $product->description = $userInput['description'];
			$product->shops_id = $userInput['shops_id'];
			$product->save();
		
            $count = 0;
			
			$files = Input::file('image');
			$titles = $userInput['img_title'];
			$descriptions = $userInput['img_description'];

			foreach ($files as $file){
				if(File::Exists($file)){
					$detail = new $this->detailModelInstance;
					$detail->product_id = $product->id ; 
					$detail->img_title = $titles[$count];
					$detail->img_description = $descriptions[$count];

					$dest = img_upload_path();
					$originalName = md5(time());
					$r = rand(1,999);
					$originalName = $originalName.$r;
					$file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
					$product->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
					$product->save();
					$detail->image = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();

					$count++;
					$detail->save();
				}
				
			}
            try {    
                $id = \Session::get('id');
                OperatorLog::saveItem($id, "新增 " . $userInput['title']);
                return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
            } catch(PDOException $e) {
                echo $e;
                return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index')
                    ->with('message', sprintf('Failed to connect to database: %s', $e));
            }

        }
		else{
			return Redirect::back()->withErrors($validator);
		}
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $categories = array();
        $products = array();
        $notification = array();
        $bonusoption = array();
		$allproducts = $this->selfModelInstance->orderBy("created_at", 'desc')->get();

        foreach ($this->classModelInstance->all() as $category) {
			if($category->show == 1)
	            $categories[$category->id] = $category->name;
            if($category->name == "集量商品")
                $special[0] = $category->id;
            else if ($category->name == "限時商品")
                $special[1] = $category->id;;
        }
        foreach ($allproducts as $pro){
            if($pro->category_id == $id){
                $products[$pro->id] = $pro;
            }
            if($pro->category_id == $id && ($pro->stock_amount < $pro->stock_threshold) ){
                $notification[$pro->id] = $pro->title;
            }
        }

        return View::make('product-management::product.show')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withCid($id)
            ->withCategories($categories)
            ->withBonusoption($bonusoption)
            ->withNotifications($notification)
			->withAllproducts($allproducts)
            ->withProducts($products);
    }

    public function getShop($id)
    {
		$shops = \Shops::orderBy("created_at", 'desc')->get();

        $products = array();
        $notification = array();
        $bonusoption = array();

        return View::make('product-management::product.shop')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withCid($id)
			->withShops($shops);
    }

	public function getShopstore($json)
	{
        $objs = json_decode($json, true);	
//		return $objs[0];
		$shop = new \Shops;
		$shop->name = $objs[0]['name'];
		$shop->region = $objs[0]['region'];
		$shop->address = $objs[0]['address'];
		$shop->position_x = $objs[0]['position_x'];
		$shop->position_y = $objs[0]['position_y'];
		$shop->save();

		return Redirect::to('admin/product/shop/1');
	}

    public function showproduct($search)
    {
        $categories = array();
        $produts = array();
        $categories[0] = "總覽";
        foreach ($this->classModelInstance->all() as $category) {
            $categories[$category->id] = $category->name;
        }
        foreach ($this->selfModelInstance->all() as $pro){
            if($pro->title.match($search)){
                $products[$pro->id] = $pro;
            }
        }
        return View::make('product-management::product.show')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withCid($id)
            ->withCategories($categories)
            ->withProducts($products);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $bonusoption = array();
        $option = array();
        $detail = array();
        $count = 0;
		$region = array();
		$shop_name = array();

		$region[0] = "全選";
		$shop_name[0] = "全選";
		foreach (\Shops::all() as $shop){
			$region[$shop->id] = $shop->region;
			$shop_name[$shop->id] = $shop->name;
		}
		$region = array_unique($region);
		$shop_name = array_unique($shop_name);

        foreach ($this->classModelInstance->all() as $product) {
            if($product->show == 1)
                $option[$product->id] = $product->name;
        }

        $product = $this->selfModelInstance->findOrFail($id);
        foreach ($this->detailModelInstance->all() as $det) {
            if($det->product_id == $id){
                $vars = json_decode($det);
                foreach ($vars as $key=>$value){
                    if(preg_match("/^img_title/", $key) || preg_match("/^img_description/", $key) || preg_match("/^id/", $key) || preg_match("/^image/", $key) ){
                        $key = $key.$count;
                        $product->$key = $value;
                    }
                }
                $detail[$count++] = $det;
            }
        }
		foreach (\Brands::all() as $br){
			$brand[$br->id] = $br->name;
		}
        return View::make('product-management::product.edit')
            ->with('_CONST', $this->_CONST)
            ->withProduct($product)
            ->withDetail($detail)
            ->withBonusoption($bonusoption)
			->withRegion($region)
			->withShopname($shop_name)
			->withAddress(\Shops::all())
			->withBrands($brand)
            ->withOption($option);

    }


    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $product = $this->selfModelInstance->findOrFail($id);
		$c = 0;
		foreach ($this->detailModelInstance->all() as $det){
			if($det->product_id == $id)
				$detailall[$c++] = $det;
		}
		if(!isset($detailall))
			$detailall = 0;
        $userInput = Input::all();
        $validator = Validator::make(
            $userInput,
            array(
                'title' => 'required',
                'price' => 'required|alpha_num',
            )
        );
//		return count($_FILES['image']);
        if ($validator->passes()) {

	        $product->category_id = $userInput['category_id'];
			$product->publish = $userInput['publish'];
            $product->title = $userInput['title'];
            $product->subheading = $userInput['subheading'];
            $product->format = $userInput['format'];
            $product->tag_1 = $userInput['tag_1'];
            $product->tag_2 = $userInput['tag_2'];
            $product->tag_3 = $userInput['tag_3'];
            $product->price = $userInput['price'];
            $product->selling_price = $userInput['selling_price'];
            $product->official_url = $userInput['official_url'];
            $product->start_date = $userInput['start_date'];
            $product->description = $userInput['description'];
			$product->shops_id = $userInput['shops_id'];

            $count = 0;

			$files = Input::file('image');

			if(isset($userInput['img_title']))
				$titles = $userInput['img_title'];
			if(isset($userInput['img_description']))
				$descriptions = $userInput['img_description'];
			
			if(isset($files)){
				foreach ($files as $file){
					if(File::Exists($file)){
						if($userInput['id'.$count] == -1)
							$detail = new $this->detailModelInstance;
						else
							$detail = $this->detailModelInstance->where('id','=',$userInput['id'.$count])->first();

						$detail->product_id = $product->id ; 
						$detail->img_title = $titles[$count];
						$detail->img_description = $descriptions[$count];

						$dest = img_upload_path();
						$originalName = md5(time());
						$r = rand(1,999);
						$originalName = $originalName.$r;
						$file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
						$product->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
						$product->save();
						$detail->image = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();

						$detail->save();
					}
					$count++;
				}
			}
            $product->save();
            $id = \Session::get('id');
            OperatorLog::saveItem($id, "編輯 " . $userInput['title']);
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }

        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.edit', $id)->withErrors($validator)->withInput();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $product = $this->selfModelInstance->findOrFail($id);
        if (file_exists($product->img_path)) {
            unlink($product->img_path);
        }
        $id = \Session::get('id');
        OperatorLog::saveItem($id, "刪除 " . $product['title']);
        $product->delete();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
	}

	/* Remove the specified shop from storage. */
    public function getShopdestroy($id)
    {
		$shop = \Shops::findOrFail($id);
        OperatorLog::saveItem($id, "刪除 " . $shop['name']);
        $shop->delete();
        return Redirect::to('admin/product/shop/1');
	}

	public function getImgdelete($img_id, $id)
	{
		echo "yooo";
		echo $id;
		$detail = $this->detailModelInstance->findOrFail($img_id);
        if (file_exists($detail->image)) {
            unlink($detail->image);
        }
		$detail->delete();

		return Redirect::route('admin.product.edit',$id);
	}

	
	/* class api for nineten. */
    public function getClassapi($id)
    {
        $option = array();
        $products = array();
		$bonusoption = array();
		$obj;
        $count = 0;

        foreach ($this->bonusCatModelInstance->all() as $bonus) {
            $bonusoption[$bonus->id] = $bonus->category;
        }
            foreach ($this->selfModelInstance->all() as $pro){
                if($pro->category_id == $id){
					$obj["product_code"] = $pro->product_code;
					$obj["title"] = $pro->title;
					$obj["format"] = $pro->format;
					$obj["price"] = $pro->price;
					$obj["selling_price"] = $pro->selling_price;
					$obj["available_amount"] = $pro->available_amount;
					$obj["stock_amount"] = $pro->stock_amount;
					$obj["special_case"] = $pro->special_case;
					$obj["bonus"] = $bonusoption[$pro->bonus_category_id];
					$obj["is_available"] = $pro->is_available;
					$obj["type"] = $pro->type;
					
                    $products[$count] = $obj;
                    $count++;
                }
            }
        return $products;
    }

	/* Edit the specified shop contents from storage. */
	public function getShopedit($id)
	{
		$shop = \Shops::findOrFail($id);

        return View::make('product-management::product.shop_edit')
            ->with('_CONST', $this->_CONST)
            ->withShop($shop);
	}

	/* Update the specified shop contents from storage. */
	public function getShopupdate($id)
	{
        $shop = \Shops::findOrFail($id);
        $userInput = Input::all();

		$validator = Validator::make(
			$userInput, array('name' => 'required', 'address' => 'required') );
		if($validator->passes()){
			$shop->name = $userInput['name'];
			$shop->address = $userInput['address'];
			$shop->position_x = $userInput['position_x'];
			$shop->position_y = $userInput['position_y'];

			$shop->save();

			$id = \Session::get('id');
			OperatorLog::saveItem($id, "編輯 " . $shop->name);
			return Redirect::to('admin/product/shop/1');
		}
		else
			return Redirect::to('admin/product/shopedit/'.$id)->withErrors($validator)->withInput();

	}

	/* Update the transaction's amount. */
	public function getInstock($id, $num)
	{
		$product = \Transaction::findOrFail($id);
		$product->amount = $num;
		$product->save();
		return Redirect::to('admin/product/order/1');
	}

	/* Show the transaction's form for new resources. */
    public function getOrder($id)
    {
		$transaction = \Transaction::all();;

        $categories = array();
        $products = array();
        $notification = array();
        $bonusoption = array();
		$statusoption = array('0'=>'全部狀態','1'=>'尚未付款','2'=>'付款完成','3'=>'已出貨','4'=>'訂單完成','5'=>'取消訂單','6'=>'退換貨處理');
		$allproducts = $this->selfModelInstance->orderBy("created_at", 'desc')->get();

        foreach ($this->classModelInstance->all() as $category) {
            $categories[$category->id] = $category->name;
        }

        foreach ($allproducts as $pro){
            if($pro->category_id == $id){
                $products[$pro->id] = $pro;
            }
            if($pro->category_id == $id && ($pro->stock_amount < $pro->stock_threshold) ){
                $notification[$pro->id] = $pro->title;
            }
        }

        return View::make('product-management::product.order')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
            ->withCid($id)
            ->withCategories($categories)
            ->withBonusoption($bonusoption)
            ->withNotifications($notification)
			->withAllproducts($allproducts)
            ->withProducts($products)
			->withTransactions($transaction)
			->withStatusoption($statusoption);
    }

	/* Show the brands managements interface. */
	public function getBrands($id)
	{
		$brands = \Brands::orderBy("created_at", 'desc')->get();

        return View::make('product-management::product.brands')
            ->withFronturl($this->getFrontUrl())
            ->with('_CONST', $this->_CONST)
			->withBrands($brands);
	}

	/* create the new brand to storage. */
	public function getBrandcreate($id)
	{
		return View::make('product-management::product.brands_create')
			->with('_CONST', $this->_CONST);
	}

	/* store the new brand to storage. */
	public function brandstore()
	{
        $userInput = Input::all();
		$brand = new \Brands;
		$brand->name = $userInput['name'];
		$brand->description = $userInput['description'];
		$brand->facebook_url = $userInput['facebook_url'];
		$brand->instagram_url = $userInput['instagram_url'];
		$brand->youtube = $userInput['youtube'];
		$brand->buynow = $userInput['buynow'];
		$brand->location = $userInput['location'];
		$brand->url = $userInput['url'];

        if(Input::hasFile('image')){
			$dest = img_upload_path();
			$file = Input::file('image');
			$originalName = md5(time());
			$r = rand(1,999);
			$originalName = $originalName.$r;
			$file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
			$brand->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
		}
        if(Input::hasFile('photo')){
			$dest = img_upload_path();
			$file = Input::file('photo');
			$originalName = md5(time());
			$r = rand(1,999);
			$originalName = $originalName.$r;
			$file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
			$brand->photo_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
		}

		$brand->save();
		return Redirect::to('admin/product/brands/1');
    }

	/* Delete the specified brand from storage. */
    public function getBranddestroy($id)
    {
		$brand = \Brands::findOrFail($id);
        $id = \Session::get('id');
        OperatorLog::saveItem($id, "刪除 " . $brand['name']);
        $brand->delete();
        return Redirect::to('admin/product/brands/1');
	}

	/* Show the brand edit interface. */
	public function getBrandedit($id)
	{
		$brand = \Brands::findOrFail($id);

        return View::make('product-management::product.brands_edit')
			->withBrand($brand)
            ->with('_CONST', $this->_CONST);
	}

	/* Update the specified brand to storage. */
	public function brandupdate($id)
	{
        $brand = \Brands::findOrFail($id);
        $userInput = Input::all();

		$brand->name = $userInput['name'];
		$brand->description = $userInput['description'];
		$brand->facebook_url = $userInput['facebook_url'];
		$brand->instagram_url = $userInput['instagram_url'];
		$brand->youtube = $userInput['youtube'];
		$brand->buynow = $userInput['buynow'];
		$brand->location = $userInput['location'];
		$brand->url = $userInput['url'];

        if(Input::hasFile('image')){
			$dest = img_upload_path();
			$file = Input::file('image');
			$originalName = md5(time());
			$r = rand(1,999);
			$originalName = $originalName.$r;
			$file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
			$brand->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
		}
        if(Input::hasFile('photo')){
			$dest = img_upload_path();
			$file = Input::file('photo');
			$originalName = md5(time());
			$r = rand(1,999);
			$originalName = $originalName.$r;
			$file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());
			$brand->photo_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
		}
		$brand->save();

		$id = \Session::get('id');
		OperatorLog::saveItem($id, "編輯 " . $brand->name);
		return Redirect::to('admin/product/brands/1');

	}

    public function getLangDest()
    {
        return "product-management::view";
    }
}
